/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.template.impl;

import com.alibaba.citrus.service.template.TemplateEngine;
import com.alibaba.citrus.service.template.impl.TemplateKey;
import com.alibaba.citrus.service.template.impl.TemplateMatchResult;

public abstract class TemplateMatcher
implements TemplateMatchResult {
    private final String originalTemplateName;
    private final String originalTemplateNameWithoutExtension;
    private final String originalExtension;
    private String templateNameWithoutExtension;
    private String extension;
    private TemplateEngine engine;

    public TemplateMatcher(TemplateKey key) {
        this.originalTemplateName = key.getTemplateName();
        this.originalTemplateNameWithoutExtension = key.getTemplateNameWithoutExtension();
        this.originalExtension = key.getExtension();
        this.templateNameWithoutExtension = key.getTemplateNameWithoutExtension();
        this.extension = key.getExtension();
    }

    public String getOriginalTemplateName() {
        return this.originalTemplateName;
    }

    public String getOriginalTemplateNameWithoutExtension() {
        return this.originalTemplateNameWithoutExtension;
    }

    public String getOriginalExtension() {
        return this.originalExtension;
    }

    public String getTemplateName() {
        return TemplateKey.getTemplateName(this.templateNameWithoutExtension, this.extension);
    }

    public String getTemplateNameWithoutExtension() {
        return this.templateNameWithoutExtension;
    }

    public void setTemplateNameWithoutExtension(String templateNameWithoutExtension) {
        this.templateNameWithoutExtension = templateNameWithoutExtension;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public TemplateEngine getEngine() {
        return this.engine;
    }

    public void setEngine(TemplateEngine engine) {
        this.engine = engine;
    }

    public abstract boolean findTemplate();

    public String toString() {
        return "TemplateMatcher[" + this.originalTemplateName + "]";
    }
}

