/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util;

import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.StringUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;

public class ServletUtil {
    public static boolean isPrefixServletMapping(HttpServletRequest request) {
        int index;
        String pathInfo = StringUtil.trimToNull(request.getPathInfo());
        if (pathInfo != null) {
            return true;
        }
        String servletPath = StringUtil.trimToEmpty(request.getServletPath());
        return servletPath.indexOf(".", (index = servletPath.lastIndexOf("/")) + 1) < 0;
    }

    public static String getResourcePath(HttpServletRequest request) {
        String pathInfo = FileUtil.normalizeAbsolutePath(request.getPathInfo(), false);
        String servletPath = FileUtil.normalizeAbsolutePath(request.getServletPath(), pathInfo.length() != 0);
        return servletPath + pathInfo;
    }

    public static String getBaseURL(HttpServletRequest request) {
        String fullPath;
        String fullURL = request.getRequestURL().toString();
        try {
            fullPath = new URL(fullURL).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + fullURL, e);
        }
        StringBuilder buf = new StringBuilder(fullURL);
        buf.setLength(fullURL.length() - fullPath.length());
        buf.append(FileUtil.normalizeAbsolutePath(request.getContextPath(), true));
        return buf.toString();
    }

    public static String getServletResourcePath(HttpServletRequest request) {
        String resourcePath = ServletUtil.isPrefixServletMapping(request) ? request.getPathInfo() : request.getServletPath();
        resourcePath = FileUtil.normalizeAbsolutePath(resourcePath, false);
        return resourcePath;
    }

    public static String getServletBaseURL(HttpServletRequest request) {
        String fullPath;
        String fullURL = request.getRequestURL().toString();
        try {
            fullPath = new URL(fullURL).getPath();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + fullURL, e);
        }
        StringBuilder buf = new StringBuilder(fullURL);
        buf.setLength(fullURL.length() - fullPath.length());
        buf.append(FileUtil.normalizeAbsolutePath(request.getContextPath(), true));
        if (ServletUtil.isPrefixServletMapping(request)) {
            buf.append(FileUtil.normalizeAbsolutePath(request.getServletPath(), true));
        }
        return buf.toString();
    }

    public static String normalizeURI(String uri) {
        return URI.create(StringUtil.trimToEmpty(uri)).normalize().toString();
    }

    public static boolean startsWithPath(String path, String fullpath) {
        if (fullpath != null && path != null) {
            if (path.endsWith("/")) {
                return fullpath.startsWith(path);
            }
            if (path.length() == fullpath.length()) {
                return fullpath.equals(path);
            }
            if (path.length() < fullpath.length()) {
                return fullpath.startsWith(path + "/");
            }
        }
        return false;
    }
}

