/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;

public class SQLOver
extends SQLObjectImpl
implements SQLReplaceable {
    protected final List<SQLExpr> partitionBy = new ArrayList<SQLExpr>();
    protected SQLOrderBy orderBy;
    protected SQLOrderBy distributeBy;
    protected SQLOrderBy sortBy;
    protected SQLOrderBy clusterBy;
    protected SQLName of;
    protected WindowingType windowingType;
    protected boolean windowingPreceding;
    protected boolean windowingFollowing;
    protected SQLExpr windowingBetweenBegin;
    protected WindowingBound windowingBetweenBeginBound;
    protected SQLExpr windowingBetweenEnd;
    protected WindowingBound windowingBetweenEndBound;
    protected boolean excludeCurrentRow;

    public SQLOver() {
    }

    public SQLOver(SQLOrderBy orderBy) {
        this.setOrderBy(orderBy);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.partitionBy != null) {
                for (SQLExpr item : this.partitionBy) {
                    if (item == null) continue;
                    item.accept(visitor);
                }
            }
            if (this.orderBy != null) {
                this.orderBy.accept(visitor);
            }
            if (this.distributeBy != null) {
                this.distributeBy.accept(visitor);
            }
            if (this.sortBy != null) {
                this.sortBy.accept(visitor);
            }
            if (this.clusterBy != null) {
                this.clusterBy.accept(visitor);
            }
            if (this.of != null) {
                this.of.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public SQLOrderBy getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(SQLOrderBy x) {
        if (x != null) {
            x.setParent(this);
        }
        this.orderBy = x;
    }

    public SQLOrderBy getClusterBy() {
        return this.clusterBy;
    }

    public void setClusterBy(SQLOrderBy x) {
        if (x != null) {
            x.setParent(this);
        }
        this.clusterBy = x;
    }

    public SQLOrderBy getDistributeBy() {
        return this.distributeBy;
    }

    public void setDistributeBy(SQLOrderBy x) {
        if (x != null) {
            x.setParent(this);
        }
        this.distributeBy = x;
    }

    public SQLOrderBy getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SQLOrderBy x) {
        if (x != null) {
            x.setParent(this);
        }
        this.sortBy = x;
    }

    public SQLName getOf() {
        return this.of;
    }

    public void setOf(SQLName of) {
        if (of != null) {
            of.setParent(this);
        }
        this.of = of;
    }

    public List<SQLExpr> getPartitionBy() {
        return this.partitionBy;
    }

    public WindowingType getWindowingType() {
        return this.windowingType;
    }

    public void setWindowingType(WindowingType windowingType) {
        this.windowingType = windowingType;
    }

    public boolean isWindowingPreceding() {
        return this.windowingPreceding;
    }

    public void setWindowingPreceding(boolean windowingPreceding) {
        this.windowingPreceding = windowingPreceding;
    }

    public SQLExpr getWindowingBetweenBegin() {
        return this.windowingBetweenBegin;
    }

    public void setWindowingBetweenBegin(SQLExpr windowingBetweenBegin) {
        this.windowingBetweenBegin = windowingBetweenBegin;
    }

    public SQLExpr getWindowingBetweenEnd() {
        return this.windowingBetweenEnd;
    }

    public void setWindowingBetweenEnd(SQLExpr windowingBetweenEnd) {
        this.windowingBetweenEnd = windowingBetweenEnd;
    }

    public boolean isWindowingBetweenEndPreceding() {
        return this.windowingBetweenEndBound == WindowingBound.PRECEDING;
    }

    public boolean isWindowingBetweenEndFollowing() {
        return this.windowingBetweenEndBound == WindowingBound.FOLLOWING;
    }

    public WindowingBound getWindowingBetweenBeginBound() {
        return this.windowingBetweenBeginBound;
    }

    public void setWindowingBetweenBeginBound(WindowingBound windowingBetweenBeginBound) {
        this.windowingBetweenBeginBound = windowingBetweenBeginBound;
    }

    public WindowingBound getWindowingBetweenEndBound() {
        return this.windowingBetweenEndBound;
    }

    public void setWindowingBetweenEndBound(WindowingBound windowingBetweenEndBound) {
        this.windowingBetweenEndBound = windowingBetweenEndBound;
    }

    public boolean isExcludeCurrentRow() {
        return this.excludeCurrentRow;
    }

    public void setExcludeCurrentRow(boolean excludeCurrentRow) {
        this.excludeCurrentRow = excludeCurrentRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLOver sqlOver = (SQLOver)o;
        if (this.windowingPreceding != sqlOver.windowingPreceding) {
            return false;
        }
        if (this.windowingFollowing != sqlOver.windowingFollowing) {
            return false;
        }
        if (!this.partitionBy.equals(sqlOver.partitionBy)) {
            return false;
        }
        if (this.orderBy != null ? !this.orderBy.equals(sqlOver.orderBy) : sqlOver.orderBy != null) {
            return false;
        }
        if (this.of != null ? !this.of.equals(sqlOver.of) : sqlOver.of != null) {
            return false;
        }
        if (this.windowingType != sqlOver.windowingType) {
            return false;
        }
        if (this.windowingBetweenBegin != null ? !this.windowingBetweenBegin.equals(sqlOver.windowingBetweenBegin) : sqlOver.windowingBetweenBegin != null) {
            return false;
        }
        if (this.windowingBetweenBeginBound != sqlOver.windowingBetweenBeginBound) {
            return false;
        }
        if (this.windowingBetweenEnd != null ? !this.windowingBetweenEnd.equals(sqlOver.windowingBetweenEnd) : sqlOver.windowingBetweenEnd != null) {
            return false;
        }
        return this.windowingBetweenEndBound == sqlOver.windowingBetweenEndBound;
    }

    public int hashCode() {
        int result = this.partitionBy != null ? this.partitionBy.hashCode() : 0;
        result = 31 * result + (this.orderBy != null ? this.orderBy.hashCode() : 0);
        result = 31 * result + (this.of != null ? this.of.hashCode() : 0);
        result = 31 * result + (this.windowingType != null ? this.windowingType.hashCode() : 0);
        result = 31 * result + (this.windowingPreceding ? 1 : 0);
        result = 31 * result + (this.windowingFollowing ? 1 : 0);
        result = 31 * result + (this.windowingBetweenBegin != null ? this.windowingBetweenBegin.hashCode() : 0);
        result = 31 * result + (this.windowingBetweenBeginBound != null ? this.windowingBetweenBeginBound.hashCode() : 0);
        result = 31 * result + (this.windowingBetweenEnd != null ? this.windowingBetweenEnd.hashCode() : 0);
        result = 31 * result + (this.windowingBetweenEndBound != null ? this.windowingBetweenEndBound.hashCode() : 0);
        return result;
    }

    public void cloneTo(SQLOver x) {
        for (SQLExpr item : this.partitionBy) {
            SQLExpr item1 = item.clone();
            item1.setParent(x);
            x.partitionBy.add(item1);
        }
        if (this.orderBy != null) {
            x.setOrderBy(this.orderBy.clone());
        }
        if (this.of != null) {
            x.setOf(this.of.clone());
        }
        x.windowingType = this.windowingType;
        x.windowingPreceding = this.windowingPreceding;
        x.windowingFollowing = this.windowingFollowing;
        if (this.windowingBetweenBegin != null) {
            x.setWindowingBetweenBegin(this.windowingBetweenBegin.clone());
        }
        x.windowingBetweenBeginBound = this.windowingBetweenBeginBound;
        x.windowingBetweenEndBound = this.windowingBetweenEndBound;
        if (this.windowingBetweenEnd != null) {
            x.setWindowingBetweenEnd(this.windowingBetweenEnd.clone());
        }
    }

    @Override
    public SQLOver clone() {
        SQLOver x = new SQLOver();
        this.cloneTo(x);
        return x;
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        if (this.windowingBetweenBegin == expr) {
            this.setWindowingBetweenBegin(target);
            return true;
        }
        if (this.windowingBetweenEnd == expr) {
            this.setWindowingBetweenEnd(target);
            return true;
        }
        for (int i = 0; i < this.partitionBy.size(); ++i) {
            if (this.partitionBy.get(i) != expr) continue;
            this.partitionBy.set(i, target);
            target.setParent(this);
        }
        return false;
    }

    public static enum WindowingType {
        ROWS("ROWS"),
        RANGE("RANGE");

        public final String name;
        public final String nameLCase;

        private WindowingType(String name) {
            this.name = name;
            this.nameLCase = name.toLowerCase();
        }
    }

    public static enum WindowingBound {
        UNBOUNDED_PRECEDING("UNBOUNDED PRECEDING"),
        PRECEDING("PRECEDING"),
        CURRENT_ROW("CURRENT ROW"),
        FOLLOWING("FOLLOWING"),
        UNBOUNDED_FOLLOWING("UNBOUNDED FOLLOWING");

        public final String name;
        public final String nameLCase;

        private WindowingBound(String name) {
            this.name = name;
            this.nameLCase = name.toLowerCase();
        }
    }
}

