/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool.ha.node;

import com.alibaba.druid.pool.ha.PropertiesUtils;
import com.alibaba.druid.pool.ha.node.NodeEvent;
import com.alibaba.druid.pool.ha.node.NodeListener;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FileNodeListener
extends NodeListener {
    private static final Log LOG = LogFactory.getLog(FileNodeListener.class);
    private Lock lock = new ReentrantLock();
    private String file = null;
    private int intervalSeconds = 60;
    private ScheduledExecutorService executor;

    @Override
    public void init() {
        super.init();
        if (this.intervalSeconds <= 0) {
            this.intervalSeconds = 60;
        }
        this.executor = Executors.newScheduledThreadPool(1);
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Checking file " + FileNodeListener.this.file + " every " + FileNodeListener.this.intervalSeconds + "s.");
                if (!FileNodeListener.this.lock.tryLock()) {
                    LOG.info("Can not acquire the lock, skip this time.");
                    return;
                }
                try {
                    FileNodeListener.this.update();
                }
                catch (Exception e) {
                    LOG.error("Can NOT update the node list.", e);
                }
                finally {
                    FileNodeListener.this.lock.unlock();
                }
            }
        }, this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
    }

    @Override
    public List<NodeEvent> refresh() {
        Properties originalProperties = PropertiesUtils.loadProperties(this.file);
        List<String> nameList = PropertiesUtils.loadNameList(originalProperties, this.getPrefix());
        Properties properties = new Properties();
        for (String n : nameList) {
            String url = originalProperties.getProperty(n + ".url");
            String username = originalProperties.getProperty(n + ".username");
            String password = originalProperties.getProperty(n + ".password");
            if (url == null || url.isEmpty()) {
                LOG.warn(n + ".url is EMPTY! IGNORE!");
                continue;
            }
            properties.setProperty(n + ".url", url);
            if (username == null || username.isEmpty()) {
                LOG.debug(n + ".username is EMPTY. Maybe you should check the config.");
            } else {
                properties.setProperty(n + ".username", username);
            }
            if (password == null || password.isEmpty()) {
                LOG.debug(n + ".password is EMPTY. Maybe you should check the config.");
                continue;
            }
            properties.setProperty(n + ".password", password);
        }
        List<NodeEvent> events = NodeEvent.getEventsByDiffProperties(this.getProperties(), properties);
        if (events != null && !events.isEmpty()) {
            LOG.info(events.size() + " different(s) detected.");
            this.setProperties(properties);
        }
        return events;
    }

    @Override
    public void destroy() {
        if (this.executor == null || this.executor.isShutdown()) {
            return;
        }
        try {
            this.executor.shutdown();
        }
        catch (Exception e) {
            LOG.error("Can NOT shutdown the ScheduledExecutorService.", e);
        }
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    public void setIntervalSeconds(int intervalSeconds) {
        this.intervalSeconds = intervalSeconds;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }
}

