/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.config;

import com.alibaba.dts.client.executor.job.processor.FailureJobProcessor;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.Machine;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.util.DiamondHelper;
import com.alibaba.dts.common.util.IniUtil;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.tmq.client.util.StringUtil;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientConfig
implements Constants {
    private static final Log logger = LogFactory.getLog(ClientConfig.class);
    private int remotingThreads = DEFAULT_REMOTING_THREADS;
    private long heartBeatIntervalTime = 120000L;
    private long connectionTimeout = 3000L;
    private String groupId;
    private String zkHosts;
    private String namespace = "zk-dts-root";
    private int zkSessionTimeout = 10000;
    private int zkConnectionTimeout = 10000;
    private boolean isSpring = false;
    private int queueSize = 10000;
    private int consumerThreads = 5;
    private Map<String, Integer> consumerThreadsMap = null;
    private String version;
    private int pageSize = 1000;
    private Map<String, Integer> pageSizeMap = null;
    private String accessKey;
    private String secretKey;
    private String localAddress;
    private String clientId;
    private boolean crashRetry = false;
    private long pullTaskListOverSleepTime = 20000L;
    private Map<String, FailureJobProcessor> failureJobProcessorMap = null;
    private StopJobProcessor stopJobProcessor = null;
    private boolean finishLog = true;
    private boolean isEveryTimeNew = false;
    private boolean zkHostsAutoChange = true;
    private long maxBodySize = 65536L;
    private String environment;
    private String signature;
    private Map<String, String> jobMap;
    private Machine machine;
    private String domainName;
    private String serviceGroup;
    private String regionName;
    private String serviceGroupId;
    private boolean autoInit = true;
    private boolean isAgent = false;
    private boolean newInstance = true;
    private String configPath;
    private long connectTime;
    private int innerDebug = 0;

    public String getServiceGroupId() {
        return this.serviceGroupId;
    }

    public void setServiceGroupId(String serviceGroupId) {
        this.serviceGroupId = serviceGroupId;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    public int getInnerDebug() {
        return this.innerDebug;
    }

    public void setInnerDebug(int innerDebug) {
        this.innerDebug = innerDebug;
    }

    public void init() throws InitException {
        Map<String, String> configMap;
        try {
            this.version = "1.6.13-SNAPSHOT";
        }
        catch (Throwable e) {
            throw new InitException("[ClientConfig]: init version error", e);
        }
        this.localAddress = RemotingUtil.getLocalAddress();
        try {
            this.clientId = UUID.randomUUID().toString() + ":" + this.localAddress;
        }
        catch (Throwable e) {
            throw new InitException("[ClientConfig]: init clientId error", e);
        }
        if (!StringUtil.isBlank(this.configPath) && (configMap = IniUtil.getIniValuesFromFile(this.configPath, "baseSection")) != null && !configMap.isEmpty()) {
            String domainName;
            String groupId = configMap.get("groupId");
            if (StringUtil.isNotBlank(groupId)) {
                this.groupId = groupId;
            }
            if (StringUtil.isNotBlank(domainName = configMap.get("domainName"))) {
                this.domainName = domainName;
            }
        }
        if ("SchedulerX".equals(this.getEnvironment())) {
            if (StringUtil.isBlank(this.domainName)) {
                this.domainName = "schedulerx.console.aliyun.com";
            }
        } else if (StringUtil.isBlank(this.domainName)) {
            try {
                this.domainName = DiamondHelper.getData("com.alibaba.dts.common.domainName", 10000L);
                DiamondHelper.addListener("com.alibaba.dts.common.domainName", new DiamondHelper.DataListener(){

                    @Override
                    public void receiveConfigInfo(String dataId, String configInfo) {
                        ClientConfig.this.domainName = configInfo;
                    }
                });
            }
            catch (Throwable e) {
                throw new InitException("[ClientConfig]: get domainName from diamond error", e);
            }
        }
        if (StringUtil.isBlank(this.domainName)) {
            throw new InitException("[ClientConfig]: domainName is empty error, domainName:" + this.domainName);
        }
    }

    public int getRemotingThreads() {
        return this.remotingThreads;
    }

    public void setRemotingThreads(int remotingThreads) {
        if (remotingThreads <= 0) {
            this.remotingThreads = DEFAULT_REMOTING_THREADS;
            logger.warn((Object)("[ClientConfig]: setRemotingThreads error, you set remotingThreads:" + remotingThreads));
            return;
        }
        if (remotingThreads > 10 * DEFAULT_REMOTING_THREADS) {
            this.remotingThreads = 10 * DEFAULT_REMOTING_THREADS;
            logger.warn((Object)("[ClientConfig]: setRemotingThreads too large, you set remotingThreads:" + remotingThreads + ", max:" + 10 * DEFAULT_REMOTING_THREADS));
            return;
        }
        this.remotingThreads = remotingThreads;
    }

    public long getHeartBeatIntervalTime() {
        return this.heartBeatIntervalTime;
    }

    public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
        if (heartBeatIntervalTime <= 0L) {
            this.heartBeatIntervalTime = 10000L;
            logger.warn((Object)("[ClientConfig]: setHeartBeatIntervalTime error, you set heartBeatIntervalTime:" + heartBeatIntervalTime));
            return;
        }
        if (heartBeatIntervalTime > 200000L) {
            this.heartBeatIntervalTime = 200000L;
            logger.warn((Object)("[ClientConfig]: setHeartBeatIntervalTime too large, you set heartBeatIntervalTime:" + heartBeatIntervalTime + ", max:" + 200000L));
            return;
        }
        this.heartBeatIntervalTime = heartBeatIntervalTime;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        if (connectionTimeout <= 0L) {
            this.connectionTimeout = 3000L;
            logger.warn((Object)("[ClientConfig]: setConnectionTimeout error, you set connectionTimeout:" + connectionTimeout));
            return;
        }
        if (connectionTimeout > 30000L) {
            this.connectionTimeout = 30000L;
            logger.warn((Object)("[ClientConfig]: setConnectionTimeout too large, you set connectionTimeout:" + connectionTimeout + ", max:" + 30000L));
            return;
        }
        this.connectionTimeout = connectionTimeout;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getZkHosts() {
        return this.zkHosts;
    }

    public void setZkHosts(String zkHosts) {
        this.zkHosts = zkHosts;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public int getZkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public void setZkSessionTimeout(int zkSessionTimeout) {
        if (zkSessionTimeout <= 0) {
            this.zkSessionTimeout = 10000;
            logger.warn((Object)("[ClientConfig]: setZkSessionTimeout error, you set zkSessionTimeout:" + zkSessionTimeout));
            return;
        }
        if (zkSessionTimeout > 200000) {
            this.zkSessionTimeout = 200000;
            logger.warn((Object)("[ClientConfig]: setZkSessionTimeout too large, you set zkSessionTimeout:" + zkSessionTimeout + ", max:" + 200000));
            return;
        }
        this.zkSessionTimeout = zkSessionTimeout;
    }

    public int getZkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        if (zkConnectionTimeout <= 0) {
            this.zkConnectionTimeout = 10000;
            logger.warn((Object)("[ClientConfig]: setZkConnectionTimeout error, you set zkConnectionTimeout:" + zkConnectionTimeout));
            return;
        }
        if (zkConnectionTimeout > 200000) {
            this.zkConnectionTimeout = 200000;
            logger.warn((Object)("[ClientConfig]: setZkConnectionTimeout too large, you set zkConnectionTimeout:" + zkConnectionTimeout + ", max:" + 200000));
            return;
        }
        this.zkConnectionTimeout = zkConnectionTimeout;
    }

    public boolean isSpring() {
        return this.isSpring;
    }

    public void setSpring(boolean isSpring) {
        this.isSpring = isSpring;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        if (queueSize <= 0) {
            this.queueSize = 10000;
            logger.warn((Object)("[ClientConfig]: setQueueSize error, you set queueSize:" + queueSize));
            return;
        }
        if (queueSize > 100000) {
            this.queueSize = 100000;
            logger.warn((Object)("[ClientConfig]: setQueueSize too large, you set queueSize:" + queueSize + ", max:" + 100000));
            return;
        }
        this.queueSize = queueSize;
    }

    public int getConsumerThreads() {
        return this.consumerThreads;
    }

    public void setConsumerThreads(int consumerThreads) {
        this.consumerThreads = this.checkConsumerThreads(consumerThreads);
    }

    public int checkConsumerThreads(int consumerThreads) {
        if (consumerThreads <= 0) {
            logger.warn((Object)("[ClientConfig]: setConsumerThreads error, you set consumerThreads:" + consumerThreads));
            return 5;
        }
        if (consumerThreads > 500) {
            logger.warn((Object)("[ClientConfig]: setConsumerThreads too large, you set consumerThreads:" + consumerThreads + ", max:" + 500));
            return 500;
        }
        return consumerThreads;
    }

    public Map<String, Integer> getConsumerThreadsMap() {
        return this.consumerThreadsMap;
    }

    public void setConsumerThreadsMap(Map<String, Integer> consumerThreadsMap) {
        this.consumerThreadsMap = consumerThreadsMap;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = this.checkPageSize(pageSize);
    }

    public int checkPageSize(int pageSize) {
        if (pageSize <= 0) {
            logger.warn((Object)("[ClientConfig]: setPageSize error, you set pageSize:" + pageSize));
            return 1000;
        }
        if (pageSize > 2000) {
            logger.warn((Object)("[ClientConfig]: setPageSize too large, you set pageSize:" + pageSize + ", max:" + 2000));
            return 2000;
        }
        return pageSize;
    }

    public Map<String, Integer> getPageSizeMap() {
        return this.pageSizeMap;
    }

    public void setPageSizeMap(Map<String, Integer> pageSizeMap) {
        this.pageSizeMap = pageSizeMap;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean isCrashRetry() {
        return this.crashRetry;
    }

    public void setCrashRetry(boolean crashRetry) {
        this.crashRetry = crashRetry;
    }

    public long getPullTaskListOverSleepTime() {
        return this.pullTaskListOverSleepTime;
    }

    public void setPullTaskListOverSleepTime(long pullTaskListOverSleepTime) {
        this.pullTaskListOverSleepTime = pullTaskListOverSleepTime;
    }

    public Map<String, FailureJobProcessor> getFailureJobProcessorMap() {
        return this.failureJobProcessorMap;
    }

    public void setFailureJobProcessorMap(Map<String, FailureJobProcessor> failureJobProcessorMap) {
        this.failureJobProcessorMap = failureJobProcessorMap;
    }

    public boolean isFinishLog() {
        return this.finishLog;
    }

    public void setFinishLog(boolean finishLog) {
        this.finishLog = finishLog;
    }

    public StopJobProcessor getStopJobProcessor() {
        return this.stopJobProcessor;
    }

    public void setStopJobProcessor(StopJobProcessor stopJobProcessor) {
        this.stopJobProcessor = stopJobProcessor;
    }

    public boolean isEveryTimeNew() {
        return this.isEveryTimeNew;
    }

    public void setEveryTimeNew(boolean isEveryTimeNew) {
        this.isEveryTimeNew = isEveryTimeNew;
    }

    public boolean isZkHostsAutoChange() {
        return this.zkHostsAutoChange;
    }

    public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
        this.zkHostsAutoChange = zkHostsAutoChange;
    }

    public long getMaxBodySize() {
        return this.maxBodySize;
    }

    public void setMaxBodySize(long maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Map<String, String> getJobMap() {
        return this.jobMap;
    }

    public void setJobMap(Map<String, String> jobMap) {
        this.jobMap = jobMap;
    }

    public Machine getMachine() {
        return this.machine;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean isAutoInit() {
        return this.autoInit;
    }

    public void setAutoInit(boolean autoInit) {
        this.autoInit = autoInit;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public boolean isAgent() {
        return this.isAgent;
    }

    public void setAgent(boolean isAgent) {
        this.isAgent = isAgent;
    }

    public boolean isNewInstance() {
        return this.newInstance;
    }

    public void setNewInstance(boolean newInstance) {
        this.newInstance = newInstance;
    }

    public String toString() {
        return "ClientConfig [remotingThreads=" + this.remotingThreads + ", heartBeatIntervalTime=" + this.heartBeatIntervalTime + ", connectionTimeout=" + this.connectionTimeout + ", groupId=" + this.groupId + ", zkHosts=" + this.zkHosts + ", namespace=" + this.namespace + ", zkSessionTimeout=" + this.zkSessionTimeout + ", zkConnectionTimeout=" + this.zkConnectionTimeout + ", isSpring=" + this.isSpring + ", queueSize=" + this.queueSize + ", consumerThreads=" + this.consumerThreads + ", consumerThreadsMap=" + this.consumerThreadsMap + ", version=" + this.version + ", pageSize=" + this.pageSize + ", pageSizeMap=" + this.pageSizeMap + ", accessKey=" + this.accessKey + ", secretKey=" + this.secretKey + ", localAddress=" + this.localAddress + ", clientId=" + this.clientId + ", crashRetry=" + this.crashRetry + ", pullTaskListOverSleepTime=" + this.pullTaskListOverSleepTime + ", failureJobProcessorMap=" + this.failureJobProcessorMap + ", stopJobProcessor=" + this.stopJobProcessor + ", finishLog=" + this.finishLog + ", isEveryTimeNew=" + this.isEveryTimeNew + ", zkHostsAutoChange=" + this.zkHostsAutoChange + ", maxBodySize=" + this.maxBodySize + ", environment=" + this.environment + ", signature=" + this.signature + ", jobMap=" + this.jobMap + ", machine=" + this.machine + ", domainName=" + this.domainName + ", serviceGroup=" + this.serviceGroup + ", regionName=" + this.regionName + ", serviceGroupId=" + this.serviceGroupId + ", autoInit=" + this.autoInit + ", isAgent=" + this.isAgent + ", newInstance=" + this.newInstance + ", configPath=" + this.configPath + ", connectTime=" + this.connectTime + ", innerDebug=" + this.innerDebug + "]";
    }
}

