/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.executor.longtime.LongTimePool;
import com.alibaba.dts.client.executor.parallel.ParallelPool;
import com.alibaba.dts.client.executor.simple.ScxSimplePool;
import com.alibaba.dts.client.executor.simple.SimplePool;
import com.alibaba.dts.client.executor.stop.StopJob;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.service.ServerService;
import com.alibaba.dts.common.util.CommonUtil;
import com.alibaba.dts.common.util.StringUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class Executor
implements Constants {
    private static final Log logger = LogFactory.getLog(Executor.class);
    private final SimplePool simplePool;
    private final ScxSimplePool scxSimplePool;
    private ParallelPool parallelPool;
    private LongTimePool longTimePool;
    private final StopJob stopJob;
    private ServerService serverService;
    private final ClientContext clientContext;

    public Executor(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.stopJob = new StopJob(this.clientContext);
        this.simplePool = new SimplePool(this.clientContext);
        this.scxSimplePool = new ScxSimplePool(this.clientContext);
        this.parallelPool = new ParallelPool(this.clientContext);
        this.serverService = this.clientContext.getClientRemoting().proxyInterface(ServerService.class);
        this.longTimePool = new LongTimePool(this.clientContext);
    }

    public Result<Boolean> executeTask(ExecutableTask executableTask) {
        Result<Boolean> result = new Result<Boolean>(false);
        boolean executeResult = false;
        executeResult = CommonUtil.isSimpleJob(executableTask.getJob().getType()) ? ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) ? this.scxSimplePool.executeTask(executableTask) : this.simplePool.executeTask(executableTask)) : (CommonUtil.isLongTimeJob(executableTask.getJob().getType()) ? this.longTimePool.executeTask(executableTask) : this.parallelPool.executeTask(executableTask));
        result.setData(executeResult);
        result.setResultCode(executeResult ? ResultCode.SUCCESS : ResultCode.FAILURE);
        return result;
    }

    public Result<Boolean> activeTask(ExecutableTask executableTask) {
        Result<Boolean> result = new Result<Boolean>(false);
        boolean executeResult = false;
        if (CommonUtil.isLongTimeJob(executableTask.getJob().getType())) {
            executeResult = this.longTimePool.activeTask(executableTask);
        }
        result.setData(executeResult);
        result.setResultCode(executeResult ? ResultCode.SUCCESS : ResultCode.FAILURE);
        return result;
    }

    public Result<Boolean> releaseCompleteTask(ExecutableTask executableTask) {
        Result<Boolean> result = new Result<Boolean>(false);
        boolean executeResult = false;
        if (CommonUtil.isLongTimeJob(executableTask.getJob().getType())) {
            executeResult = this.longTimePool.releaseCompleteTask(executableTask);
        }
        result.setData(executeResult);
        result.setResultCode(executeResult ? ResultCode.SUCCESS : ResultCode.FAILURE);
        return result;
    }

    public Result<Boolean> stopTask(int jobType, long jobId, long jobInstanceId) {
        Result<Boolean> result = new Result<Boolean>(false);
        boolean stopResult = false;
        stopResult = CommonUtil.isSimpleJob(jobType) ? ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) ? this.scxSimplePool.stopTask(jobId, jobInstanceId) : this.simplePool.stopTask(jobId, jobInstanceId)) : (CommonUtil.isLongTimeJob(jobType) ? this.longTimePool.stopTask(jobId, jobInstanceId) : this.parallelPool.stopTask(jobId, jobInstanceId));
        this.stopJob.stopTask(jobId, jobInstanceId);
        result.setData(stopResult);
        result.setResultCode(stopResult ? ResultCode.SUCCESS : ResultCode.FAILURE);
        return result;
    }

    public Result<Boolean> forceStopTask(ExecutableTask executableTask) {
        Result<Boolean> result = new Result<Boolean>(false);
        boolean stopResult = false;
        stopResult = CommonUtil.isSimpleJob(executableTask.getJob().getType()) ? ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) ? this.scxSimplePool.forceStopTask(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId()) : this.simplePool.forceStopTask(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId())) : (CommonUtil.isLongTimeJob(executableTask.getJob().getType()) ? this.longTimePool.forceStopTask(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId()) : this.parallelPool.forceStopTask(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId()));
        this.stopJob.stopTask(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId());
        result.setData(stopResult);
        result.setResultCode(stopResult ? ResultCode.SUCCESS : ResultCode.FAILURE);
        return result;
    }

    public Result<ExecutableTask> pull(ExecutableTask executableTask) {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error((Object)("[Executor]: pull serverList is isEmpty error, instanceId:" + executableTask.getJobInstanceSnapshot().getId()));
            return null;
        }
        Collections.shuffle(serverList);
        Result<ExecutableTask> result = null;
        for (String server : serverList) {
            try {
                InvocationContext.setRemoteMachine(new RemoteMachine(server, 60000L));
                result = this.serverService.pull(executableTask);
            }
            catch (Throwable e) {
                logger.error((Object)("[Executor]: serverService pull error, instanceId:" + executableTask.getJobInstanceSnapshot().getId() + ", server:" + server), e);
            }
            if (null == result) {
                logger.error((Object)("[Executor]: serverService pull failed, instanceId:" + executableTask.getJobInstanceSnapshot().getId() + ", server:" + server));
                continue;
            }
            return result;
        }
        return result;
    }

    public Result<ExecutableTask> pullLongTimeTask(ExecutableTask executableTask) {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error((Object)("[Executor]: pull serverList is isEmpty error, instanceId:" + executableTask.getJobInstanceSnapshot().getId()));
            return null;
        }
        Collections.shuffle(serverList);
        Result<ExecutableTask> result = null;
        for (String server : serverList) {
            try {
                InvocationContext.setRemoteMachine(new RemoteMachine(server, 60000L));
                result = this.serverService.pullLongTimeTask(executableTask);
            }
            catch (Throwable e) {
                logger.error((Object)("[Executor]: serverService pullLongTimeTask error, instanceId:" + executableTask.getJobInstanceSnapshot().getId() + ", server:" + server), e);
            }
            if (null == result) {
                logger.error((Object)("[Executor]: serverService pullLongTimeTask failed, instanceId:" + executableTask.getJobInstanceSnapshot().getId() + ", server:" + server));
                continue;
            }
            return result;
        }
        return result;
    }

    public void acknowledge(TaskSnapshot taskSnapshot, int status, int retryTimes) {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error((Object)("[Executor]: acknowledge serverList is isEmpty error, status:" + status + ", retryTimes:" + retryTimes + ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId()));
            return;
        }
        Collections.shuffle(serverList);
        if (StringUtil.isBlank(taskSnapshot.getClientId())) {
            taskSnapshot.setClientId(this.clientContext.getClientConfig().getClientId());
        }
        taskSnapshot.setStatus(status);
        for (String server : serverList) {
            Result<Boolean> acknowledgeResult = null;
            try {
                InvocationContext.setRemoteMachine(new RemoteMachine(server, 60000L));
                acknowledgeResult = this.serverService.acknowledge(taskSnapshot);
            }
            catch (Throwable e) {
                logger.error((Object)("[Executor]: acknowledge error, status:" + status + ", retryTimes:" + retryTimes + ", server:" + server + ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId()), e);
            }
            if (null == acknowledgeResult || !acknowledgeResult.getData().booleanValue()) {
                logger.error((Object)("[Executor]: acknowledge failed, status:" + status + ", retryTimes:" + retryTimes + ", server:" + server + ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId() + ", acknowledgeResult:" + acknowledgeResult));
                continue;
            }
            return;
        }
    }

    public Result<Boolean> acknowledgeRes(TaskSnapshot taskSnapshot, int status, int retryTimes) {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error((Object)("[Executor]: acknowledge serverList is isEmpty error, status:" + status + ", retryTimes:" + retryTimes + ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId()));
            return null;
        }
        Collections.shuffle(serverList);
        if (StringUtil.isBlank(taskSnapshot.getClientId())) {
            taskSnapshot.setClientId(this.clientContext.getClientConfig().getClientId());
        }
        taskSnapshot.setStatus(status);
        taskSnapshot.setRetryCount(retryTimes);
        Result<Boolean> acknowledgeResult = null;
        for (String server : serverList) {
            try {
                InvocationContext.setRemoteMachine(new RemoteMachine(server, 60000L));
                acknowledgeResult = this.serverService.acknowledge(taskSnapshot);
            }
            catch (Throwable e) {
                logger.error((Object)("[Executor]: acknowledge error, status:" + status + ", retryTimes:" + retryTimes + ", server:" + server + ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId()), e);
            }
            if (null == acknowledgeResult || !acknowledgeResult.getData().booleanValue()) {
                logger.error((Object)("[Executor]: acknowledge failed, status:" + status + ", retryTimes:" + retryTimes + ", server:" + server + ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId() + ", acknowledgeResult:" + acknowledgeResult));
                continue;
            }
            return acknowledgeResult;
        }
        return acknowledgeResult;
    }

    public Result<String> heartBeatCheckJobInstance(int jobType, long jobId, long jobInstanceId) {
        Result<String> result = new Result();
        result = CommonUtil.isSimpleJob(jobType) ? ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) ? this.scxSimplePool.heartBeatCheckJobInstance(jobId, jobInstanceId) : this.simplePool.heartBeatCheckJobInstance(jobId, jobInstanceId)) : (CommonUtil.isLongTimeJob(jobType) ? this.longTimePool.heartBeatCheckJobInstance(jobId, jobInstanceId) : this.parallelPool.heartBeatCheckJobInstance(jobId, jobInstanceId));
        return result;
    }

    public Result<Boolean> push(int jobType, long jobId, long jobInstanceId, TaskSnapshot taskSnapshot) {
        if (!CommonUtil.isSimpleJob(jobType)) {
            if (CommonUtil.isLongTimeJob(jobType)) {
                return this.longTimePool.push(jobId, jobInstanceId, taskSnapshot);
            }
            return this.parallelPool.push(jobId, jobInstanceId, taskSnapshot);
        }
        return new Result<Boolean>(false, ResultCode.PUSH_JOB_TYPE_ERROR);
    }

    public Result<Boolean> taskStatesReport(long jobInstanceId, List<Long> taskids) {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error((Object)("[Executor]: taskStatesReport serverList is isEmpty error, instanceId:" + jobInstanceId + ", ids:" + taskids));
            return null;
        }
        Collections.shuffle(serverList);
        Result<Boolean> taskStatesReportResult = null;
        for (String server : serverList) {
            try {
                InvocationContext.setRemoteMachine(new RemoteMachine(server, 60000L));
                taskStatesReportResult = this.serverService.longTimeTaskStatesReport(jobInstanceId, taskids);
            }
            catch (Throwable e) {
                logger.error((Object)("[Executor]: taskStatesReport error, server:" + server + ", instanceId:" + jobInstanceId + ", ids:" + taskids), e);
            }
            if (null == taskStatesReportResult || !taskStatesReportResult.getData().booleanValue()) {
                logger.error((Object)("[Executor]: taskStatesReport failed, server:" + server + ", instanceId:" + jobInstanceId + ", id:" + taskids + ", taskStatesReportResult:" + taskStatesReportResult));
                continue;
            }
            return taskStatesReportResult;
        }
        return taskStatesReportResult;
    }

    public SimplePool getSimplePool() {
        return this.simplePool;
    }

    public ScxSimplePool getScxSimplePool() {
        return this.scxSimplePool;
    }

    public LongTimePool getLongTimePool() {
        return this.longTimePool;
    }
}

