/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.longtime.processor;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.executor.job.processor.LongTimeJobProcessor;
import com.alibaba.dts.client.executor.longtime.LongTimePool;
import com.alibaba.dts.client.executor.longtime.processor.LongTimeJobContext;
import com.alibaba.dts.client.executor.longtime.unit.ExecutorUnit;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.middleware.innerlog.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LongTimeTaskProcessor
extends Thread
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(LongTimeTaskProcessor.class);
    private static final Logger executeLogger = SchedulerXLoggerFactory.getExecuteLogger();
    private ExecutorUnit executorUnit;
    private volatile boolean stop = false;
    private int status = 0;
    private AtomicInteger threadCounter;
    private LongTimeJobContext context;
    private final ClientContext clientContext;

    public LongTimeTaskProcessor(ClientContext clientContext, ExecutorUnit executorUnit, int index, AtomicInteger threadCounter) {
        this.clientContext = clientContext;
        this.executorUnit = executorUnit;
        super.setName("DtsTaskProcessor-" + executorUnit.getExecutableTask().getJob().getId() + "-" + executorUnit.getExecutableTask().getJob().getJobProcessor() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getFireTime() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount() + "-" + index);
        this.threadCounter = threadCounter;
        this.context = new LongTimeJobContext(clientContext, this.executorUnit.getExecutableTask().getJob(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot(), executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount());
        String[] jobProcessorProperties = executorUnit.getExecutableTask().getJob().getJobProcessor().split(":");
        String jobProcessor = jobProcessorProperties[0].trim();
        if (this.clientContext.getClientConfig().getFailureJobProcessorMap() == null || this.clientContext.getClientConfig().getFailureJobProcessorMap().get(jobProcessor) != null) {
            // empty if block
        }
        this.context.setAvailableMachineAmount(this.executorUnit.getExecutableTask().getAvailableMachineAmount());
        this.context.setCurrentMachineNumber(this.executorUnit.getExecutableTask().getCurrentMachineNumber());
    }

    public void refresh(ExecutorUnit executorUnit, int index) {
        this.executorUnit = executorUnit;
        super.setName("DtsTaskProcessor-" + executorUnit.getExecutableTask().getJob().getId() + "-" + executorUnit.getExecutableTask().getJob().getJobProcessor() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getId() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getFireTime() + "-" + executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount() + "-" + index);
        this.context = new LongTimeJobContext(this.clientContext, this.executorUnit.getExecutableTask().getJob(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot(), executorUnit.getExecutableTask().getJobInstanceSnapshot().getRetryCount());
        String[] jobProcessorProperties = executorUnit.getExecutableTask().getJob().getJobProcessor().split(":");
        String jobProcessor = jobProcessorProperties[0].trim();
        if (this.clientContext.getClientConfig().getFailureJobProcessorMap() == null || this.clientContext.getClientConfig().getFailureJobProcessorMap().get(jobProcessor) != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            LongTimeJobProcessor longTimeJobProcessor = null;
            try {
                longTimeJobProcessor = this.clientContext.getJobProcessorFactory().createAndGetLongTimeJobProcessor(this.executorUnit.getExecutableTask().getJob(), false);
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]: createAndGetLongTimeJobProcessor error, jobProcessor:" + this.executorUnit.getExecutableTask().getJob().getJobProcessor(), e);
            }
            BlockingQueue<TaskSnapshot> queue = this.executorUnit.getQueue();
            while (!this.stop) {
                TaskSnapshot taskSnapshot = null;
                try {
                    taskSnapshot = queue.poll(10000L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable e) {
                    logger.error("[LongTimeTaskProcessor]: take executableTask error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
                }
                if (null == taskSnapshot) continue;
                this.executeTask(taskSnapshot, longTimeJobProcessor);
            }
            return;
        }
        catch (Throwable e) {
            logger.error("[LongTimeTaskProcessor]: run error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
            return;
        }
        finally {
            try {
                LongTimePool longTimePool = this.executorUnit.getLongTimePool();
                longTimePool.stopTask(this.executorUnit.getExecutableTask().getJob().getId(), this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]: finally stopTask error, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId(), e);
            }
            finally {
                if (this.clientContext.getClientConfig().isFinishLog()) {
                    logger.warn("[LongTimeTaskProcessor]: finally stopTask, instanceId:" + this.executorUnit.getExecutableTask().getJobInstanceSnapshot().getId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(TaskSnapshot taskSnapshot, LongTimeJobProcessor longTimeJobProcessor) {
        if (null == longTimeJobProcessor) {
            logger.error("[LongTimeTaskProcessor]: jobProcessor is null, please check " + this.executorUnit.getExecutableTask().getJob().getJobProcessor());
            this.clientContext.getExecutor().acknowledge(taskSnapshot, 4, 0);
            return;
        }
        long startTime = 0L;
        long runtime = 0L;
        this.status = 1;
        this.threadCounter.incrementAndGet();
        ProcessResult processResult = null;
        try {
            this.context.setTask(taskSnapshot);
            try {
                startTime = System.currentTimeMillis();
                executeLogger.warn("longTimeJobProcessor start...,instanceId:" + taskSnapshot.getJobInstanceId() + ",taskId:" + taskSnapshot.getId());
                processResult = longTimeJobProcessor.process(this.context);
                runtime = System.currentTimeMillis() - startTime;
                executeLogger.warn("longTimeJobProcessor end...,instanceId:" + taskSnapshot.getJobInstanceId() + ",taskId:" + taskSnapshot.getId() + ",runtime:" + runtime + ",processResult:" + processResult.toString());
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]: process error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
            if (null == processResult) {
                logger.error("[LongTimeTaskProcessor]: process error, processResult is null, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
                processResult = new ProcessResult(false);
            }
            this.handleTaskPost(taskSnapshot, processResult, runtime);
            this.threadCounter.decrementAndGet();
        }
        catch (Throwable e) {
            try {
                logger.error("[LongTimeTaskProcessor]: executeTask error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.handleTaskPost(taskSnapshot, processResult, runtime);
                this.threadCounter.decrementAndGet();
                this.status = 0;
            }
        }
        this.status = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskPost(TaskSnapshot taskSnapshot, ProcessResult processResult, long runtime) {
        Long sleeptime = 50L;
        if (processResult != null && processResult.getSleepTime() >= 0L) {
            sleeptime = processResult.getSleepTime();
            try {
                Thread.sleep(sleeptime);
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]:  post process error, thread:" + Thread.currentThread().getName(), e);
            }
            finally {
                if (!taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf")) {
                    this.executorUnit.taskPostProcess(taskSnapshot);
                }
            }
        } else {
            try {
                Thread.sleep(sleeptime);
            }
            catch (Throwable e) {
                logger.error("[LongTimeTaskProcessor]:  post process error, thread:" + Thread.currentThread().getName(), e);
            }
            finally {
                if (!taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf")) {
                    this.executorUnit.taskPostProcess(taskSnapshot);
                }
            }
        }
        try {
            Result<Boolean> ackResult = null;
            if (this.executorUnit.isExistsInTaskRunStatisticMap(taskSnapshot.getId())) {
                if (!taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf")) {
                    if (processResult.isSuccess()) {
                        if (this.executorUnit.getTaskRunStatisticMap().get(taskSnapshot.getId()).getProcessResult() != 6) {
                            ackResult = this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 6, 0);
                            if (null == ackResult || !ackResult.getData().booleanValue()) {
                                this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 8);
                            } else {
                                this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 6);
                            }
                        } else {
                            this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime);
                        }
                    } else if (this.executorUnit.getTaskRunStatisticMap().get(taskSnapshot.getId()).getProcessResult() != 4) {
                        ackResult = this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 4, 0);
                        if (null == ackResult || !ackResult.getData().booleanValue()) {
                            this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 8);
                        } else {
                            this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime, 4);
                        }
                    } else {
                        this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime);
                    }
                } else {
                    this.executorUnit.updateTaskRunStatisticMap(taskSnapshot.getId(), runtime);
                }
            } else {
                ackResult = taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf") ? this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 3, 0) : this.clientContext.getExecutor().acknowledgeRes(taskSnapshot, 6, 0);
                if (processResult.isSuccess()) {
                    if (taskSnapshot.getTaskName().equals("defaultTaskName4DtsServerSelf")) {
                        if (null == ackResult || !ackResult.getData().booleanValue()) {
                            this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 8);
                        } else {
                            this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 3);
                        }
                    } else if (null == ackResult || !ackResult.getData().booleanValue()) {
                        this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 8);
                    } else {
                        this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 6);
                    }
                } else if (null == ackResult || !ackResult.getData().booleanValue()) {
                    this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 8);
                } else {
                    this.executorUnit.addTaskRunStatisticMap(taskSnapshot.getId(), 4);
                }
            }
        }
        catch (Throwable e) {
            logger.error("[LongTimeTaskProcessor]:  acknowledge process error, thread:" + Thread.currentThread().getName(), e);
        }
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public int getStatus() {
        return this.status;
    }
}

