/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.executor.simple.processor.SimpleTaskProcessor;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.middleware.innerlog.Logger;
import java.util.concurrent.ConcurrentHashMap;

public class SimplePool {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SimplePool.class);
    private ConcurrentHashMap<Long, ConcurrentHashMap<Long, SimpleTaskProcessor>> simpleJobTable = new ConcurrentHashMap();
    private final ClientContext clientContext;

    public SimplePool(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    public boolean executeTask(ExecutableTask executableTask) {
        try {
            logger.info("executeTask start......");
            ConcurrentHashMap<Long, SimpleTaskProcessor> instanceTable = this.simpleJobTable.get(executableTask.getJob().getId());
            if (null == instanceTable) {
                instanceTable = new ConcurrentHashMap();
                ConcurrentHashMap<Long, SimpleTaskProcessor> existInstanceTable = this.simpleJobTable.put(executableTask.getJob().getId(), instanceTable);
                if (existInstanceTable != null) {
                    instanceTable = existInstanceTable;
                }
            }
            SimpleTaskProcessor simpleTaskProcessor = new SimpleTaskProcessor(this.clientContext, executableTask);
            simpleTaskProcessor.start();
            instanceTable.put(executableTask.getJobInstanceSnapshot().getId(), simpleTaskProcessor);
        }
        catch (Throwable e) {
            logger.error("[SimplePool]: executeTask error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
            return false;
        }
        return true;
    }

    public int getInstanceAmount(Job job) {
        ConcurrentHashMap<Long, SimpleTaskProcessor> instanceTable = this.simpleJobTable.get(job.getId());
        if (null == instanceTable) {
            return 0;
        }
        return instanceTable.size();
    }

    public boolean stopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, SimpleTaskProcessor> instanceTable = this.simpleJobTable.get(jobId);
        if (null == instanceTable) {
            return true;
        }
        SimpleTaskProcessor simpleTaskProcessor = instanceTable.get(jobInstanceId);
        if (null == simpleTaskProcessor) {
            return true;
        }
        try {
            Job job = new Job();
            job.setId(jobId);
            JobInstanceSnapshot jobInstanceSnapshot = new JobInstanceSnapshot();
            jobInstanceSnapshot.setId(jobInstanceId);
            this.removeTask(new ExecutableTask(job, jobInstanceSnapshot));
        }
        catch (Throwable e) {
            logger.error("[SimplePool]: stopTask removeTask error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
            return false;
        }
        return true;
    }

    public boolean forceStopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, SimpleTaskProcessor> instanceTable = this.simpleJobTable.get(jobId);
        if (null == instanceTable) {
            return true;
        }
        SimpleTaskProcessor simpleTaskProcessor = instanceTable.get(jobInstanceId);
        if (null == simpleTaskProcessor) {
            return true;
        }
        try {
            simpleTaskProcessor.stop();
        }
        catch (Throwable e) {
            logger.error("[SimplePool]: forceStopTask error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
        }
        try {
            Job job = new Job();
            job.setId(jobId);
            JobInstanceSnapshot jobInstanceSnapshot = new JobInstanceSnapshot();
            jobInstanceSnapshot.setId(jobInstanceId);
            this.removeTask(new ExecutableTask(job, jobInstanceSnapshot));
        }
        catch (Throwable e) {
            logger.error("[SimplePool]: forceStopTask removeTask error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
            return false;
        }
        return true;
    }

    public void removeTask(ExecutableTask executableTask) {
        try {
            ConcurrentHashMap<Long, SimpleTaskProcessor> instanceTable = this.simpleJobTable.get(executableTask.getJob().getId());
            if (null == instanceTable) {
                logger.warn("[SimplePool]: removeTask warn instanceTable is null, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
                return;
            }
            SimpleTaskProcessor simpleTaskProcessor = instanceTable.get(executableTask.getJobInstanceSnapshot().getId());
            if (null == simpleTaskProcessor) {
                logger.warn("[SimplePool]: removeTask warn simpleTaskProcessor is null, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
                return;
            }
            instanceTable.remove(executableTask.getJobInstanceSnapshot().getId());
            if (instanceTable.size() <= 0) {
                this.simpleJobTable.remove(executableTask.getJob().getId());
            }
        }
        catch (Throwable e) {
            logger.error("[SimplePool]: removeTask error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
        }
    }

    public Result<String> heartBeatCheckJobInstance(long jobId, long jobInstanceId) {
        Result<String> result = new Result<String>();
        ConcurrentHashMap<Long, SimpleTaskProcessor> instanceTable = this.simpleJobTable.get(jobId);
        if (null == instanceTable) {
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_FAILURE);
            return result;
        }
        SimpleTaskProcessor simpleTaskProcessor = instanceTable.get(jobInstanceId);
        if (null == simpleTaskProcessor) {
            JobRunningStateManager.getManageHandler().deleteJobRunningState(jobInstanceId);
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_FAILURE);
            return result;
        }
        result.setResultCode(ResultCode.HEART_BEAT_CHECK_SUCCESS);
        result.setData(JobRunningStateManager.getManageHandler().getJobRunningStateDescribe(jobInstanceId));
        return result;
    }

    public ConcurrentHashMap<Long, ConcurrentHashMap<Long, SimpleTaskProcessor>> getSimpleJobTable() {
        return this.simpleJobTable;
    }
}

