/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.executor.job.processor.SimpleJobProcessor;
import com.alibaba.dts.client.executor.simple.processor.SimpleJobContext;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.util.scripts.ScriptsUtil;
import com.alibaba.middleware.innerlog.Logger;
import java.util.Arrays;

public class DefaultScriptsJobProcessor
implements SimpleJobProcessor {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DefaultScriptsJobProcessor.class);

    @Override
    public ProcessResult process(SimpleJobContext context) {
        String jobProcessor = context.getJob().getJobProcessor();
        String information = "jobId:" + context.getJob().getId() + ", fireTime:" + context.getJobInstanceSnapshot().getFireTime();
        int executeResult = -1;
        try {
            Object[] command = ScriptsUtil.processCommand(jobProcessor);
            if (null == command || command.length <= 0) {
                logger.error("[DefaultSimpleJobProcessor]: jobProcessor command error, jobProcessor:" + jobProcessor + ", command:" + Arrays.toString(command));
                return new ProcessResult(false);
            }
            executeResult = ScriptsUtil.executeCommand((String[])command, information);
        }
        catch (Throwable e) {
            logger.error("[DefaultSimpleJobProcessor]: process error, jobProcessor:" + jobProcessor, e);
            return new ProcessResult(false);
        }
        return new ProcessResult(0 == executeResult);
    }
}

