/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.DtsLogger;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.edas.schedulerX.ScxSimpleJobContext;
import com.alibaba.edas.schedulerX.ScxSimpleJobProcessor;
import com.alibaba.middleware.innerlog.Logger;

public class ScxSimpleTaskProcessor
extends Thread
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ScxSimpleTaskProcessor.class);
    private static final Logger executeLogger = SchedulerXLoggerFactory.getExecuteLogger();
    private ExecutableTask executableTask;
    private int status = 0;
    private ScxSimpleJobContext context;
    private final ClientContext clientContext;

    public ScxSimpleTaskProcessor(ClientContext clientContext, ExecutableTask executableTask) {
        this.clientContext = clientContext;
        this.executableTask = executableTask;
        super.setName("ScxTaskProcessor-" + executableTask.getJob().getId() + "-" + executableTask.getJob().getJobProcessor() + "-" + executableTask.getJobInstanceSnapshot().getId() + "-" + executableTask.getJobInstanceSnapshot().getFireTime() + "-" + executableTask.getJobInstanceSnapshot().getRetryCount());
        this.context = new ScxSimpleJobContext(executableTask.getJob(), executableTask.getJobInstanceSnapshot(), executableTask.getJobInstanceSnapshot().getRetryCount());
        this.context.setAvailableMachineAmount(executableTask.getAvailableMachineAmount());
        this.context.setCurrentMachineNumber(executableTask.getCurrentMachineNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.status = 1;
        if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "task init start ...");
        }
        try {
            ScxSimpleJobProcessor scxSimpleJobProcessor;
            block9: {
                scxSimpleJobProcessor = null;
                try {
                    scxSimpleJobProcessor = this.clientContext.getJobProcessorFactory().createAndGetScxSimpleJobProcessor(this.executableTask.getJob(), false);
                }
                catch (Throwable e) {
                    logger.error("[ScxSimpleTaskProcessor]: createAndGetSimpleJobProcessor error, jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
                    executeLogger.error("jobId:" + this.executableTask.getJob().getId() + ",jobInstanceId:" + this.executableTask.getJobInstanceSnapshot().getId() + ",createAndGetSimpleJobProcessor error" + ", jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
                    if (!"JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) break block9;
                    DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "createAndGetSimpleJobProcessor error, jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
                }
            }
            if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "task execute start ...");
            }
            executeLogger.info("jobId:" + this.executableTask.getJob().getId() + ",jobInstanceId:" + this.executableTask.getJobInstanceSnapshot().getId() + ",task execute start......");
            this.executeTask(this.executableTask, scxSimpleJobProcessor);
            executeLogger.info("jobId:" + this.executableTask.getJob().getId() + ",jobInstanceId:" + this.executableTask.getJobInstanceSnapshot().getId() + ",task execute end......");
        }
        catch (Throwable e) {
            logger.error("[ScxSimpleTaskProcessor]: executeTask error, instanceId:" + this.executableTask.getJobInstanceSnapshot().getId(), e);
        }
        finally {
            this.status = 0;
            this.clientContext.getExecutor().getScxSimplePool().removeTask(this.executableTask);
        }
    }

    private void executeTask(ExecutableTask executableTask, ScxSimpleJobProcessor scxSimpleJobProcessor) {
        TaskSnapshot taskSnapshot = executableTask.getTaskSnapshot();
        if (null == scxSimpleJobProcessor) {
            logger.error("[ScxSimpleTaskProcessor]: jobProcessor is null, please check " + executableTask.getJob().getJobProcessor());
            executeLogger.error("jobId:" + executableTask.getJob().getId() + ",jobInstanceId:" + executableTask.getJobInstanceSnapshot().getId() + ",jobProcessor is null," + executableTask.getJob().getJobProcessor());
            if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId(), "jobProcessor is null, please check " + executableTask.getJob().getJobProcessor());
            }
            this.clientContext.getExecutor().acknowledge(taskSnapshot, 4, 0);
            return;
        }
        this.context.setTask(taskSnapshot);
        ProcessResult processResult = null;
        boolean happenException = false;
        try {
            processResult = scxSimpleJobProcessor.process(this.context);
        }
        catch (Throwable e) {
            happenException = true;
            logger.error("[ScxSimpleTaskProcessor]: process error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
            executeLogger.error("jobId:" + executableTask.getJob().getId() + ",jobInstanceId:" + executableTask.getJobInstanceSnapshot().getId() + ",happen exception:", e);
            JobRunningStateManager.getManageHandler().addJobRunningException(executableTask.getJobInstanceSnapshot().getId(), e);
        }
        if (null == processResult) {
            logger.error("[ScxSimpleTaskProcessor]: process error, processResult is null, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
            processResult = new ProcessResult(false);
            executeLogger.error("jobId:" + executableTask.getJob().getId() + ",jobInstanceId:" + executableTask.getJobInstanceSnapshot().getId() + "process error, processResult is null!");
            if (!happenException) {
                JobRunningStateManager.getManageHandler().addJobRunningException(executableTask.getJobInstanceSnapshot().getId(), new Throwable("processResult is null!"));
            }
        }
        this.handleRetryCount(taskSnapshot, processResult);
        this.clientContext.getExecutor().acknowledge(taskSnapshot, processResult.isSuccess() ? 3 : 4, processResult.getRetryCount());
        executeLogger.info("jobId:" + executableTask.getJob().getId() + ",jobInstanceId:" + executableTask.getJobInstanceSnapshot().getId() + ",task processResult:" + processResult.toString());
        if (processResult != null && !processResult.isSuccess() && !happenException) {
            JobRunningStateManager.getManageHandler().addJobRunningException(executableTask.getJobInstanceSnapshot().getId(), new Throwable("processor return failure!"));
        }
        if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId(), "task execute end, processResult:" + processResult);
        }
    }

    private void handleRetryCount(TaskSnapshot taskSnapshot, ProcessResult processResult) {
        if (processResult.isSuccess()) {
            processResult.setRetryCount(0);
            return;
        }
        if (this.executableTask.isCompensation()) {
            if (taskSnapshot.getRetryCount() > 0) {
                processResult.setRetryCount(taskSnapshot.getRetryCount() - 1);
            } else {
                processResult.setRetryCount(0);
            }
            return;
        }
        if (processResult.getRetryCount() > 100) {
            processResult.setRetryCount(100);
            return;
        }
    }

    public int getStatus() {
        return this.status;
    }
}

