/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.executor.job.context.JobContext;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.util.BytesUtil;
import com.alibaba.middleware.innerlog.Logger;

public class SimpleJobContext
extends JobContext
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SimpleJobContext.class);
    private Object task;
    private int availableMachineAmount;
    private int currentMachineNumber;

    public SimpleJobContext() {
    }

    public SimpleJobContext(Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
        super(job, jobInstanceSnapshot, retryCount);
    }

    protected void setTask(TaskSnapshot taskSnapshot) {
        if (BytesUtil.isEmpty(taskSnapshot.getBody())) {
            logger.error("[SimpleJobContext]: BytesUtil setTask bytesToObject error, body is empty, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
            return;
        }
        try {
            this.task = BytesUtil.bytesToObject(taskSnapshot.getBody());
        }
        catch (Throwable e) {
            logger.error("[SimpleJobContext]: BytesUtil setTask bytesToObject error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
        }
    }

    public void updateJobRunningStatus(String status) {
        JobRunningStateManager.getManageHandler().addJobRunningState(this.jobInstanceSnapshot.getId(), status);
    }

    public Object getTask() {
        return this.task;
    }

    public int getAvailableMachineAmount() {
        return this.availableMachineAmount;
    }

    protected void setAvailableMachineAmount(int availableMachineAmount) {
        this.availableMachineAmount = availableMachineAmount;
    }

    public int getCurrentMachineNumber() {
        return this.currentMachineNumber;
    }

    protected void setCurrentMachineNumber(int currentMachineNumber) {
        this.currentMachineNumber = currentMachineNumber;
    }
}

