/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.executor.job.processor.SimpleJobProcessor;
import com.alibaba.dts.client.executor.simple.processor.DefaultScriptsJobProcessor;
import com.alibaba.dts.client.executor.simple.processor.SimpleJobContext;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.DtsLogger;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.middleware.innerlog.Logger;

public class SimpleTaskProcessor
extends Thread
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SimpleTaskProcessor.class);
    private static final Logger executeLogger = SchedulerXLoggerFactory.getExecuteLogger();
    private ExecutableTask executableTask;
    private int status = 0;
    private SimpleJobContext context;
    private final ClientContext clientContext;

    public SimpleTaskProcessor(ClientContext clientContext, ExecutableTask executableTask) {
        this.clientContext = clientContext;
        this.executableTask = executableTask;
        super.setName("DtsTaskProcessor-" + executableTask.getJob().getId() + "-" + executableTask.getJob().getJobProcessor() + "-" + executableTask.getJobInstanceSnapshot().getId() + "-" + executableTask.getJobInstanceSnapshot().getFireTime() + "-" + executableTask.getJobInstanceSnapshot().getRetryCount());
        this.context = new SimpleJobContext(executableTask.getJob(), executableTask.getJobInstanceSnapshot(), executableTask.getJobInstanceSnapshot().getRetryCount());
        this.context.setAvailableMachineAmount(executableTask.getAvailableMachineAmount());
        this.context.setCurrentMachineNumber(executableTask.getCurrentMachineNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.status = 1;
        if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "task init start ...");
        }
        try {
            SimpleJobProcessor simpleJobProcessor;
            block9: {
                simpleJobProcessor = null;
                try {
                    simpleJobProcessor = this.clientContext.getClientConfig().isAgent() ? new DefaultScriptsJobProcessor() : this.clientContext.getJobProcessorFactory().createAndGetSimpleJobProcessor(this.executableTask.getJob(), false);
                }
                catch (Throwable e) {
                    logger.error("[SimpleTaskProcessor]: createAndGetSimpleJobProcessor error, jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
                    if (!"JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) break block9;
                    DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "createAndGetSimpleJobProcessor error, jobProcessor:" + this.executableTask.getJob().getJobProcessor(), e);
                }
            }
            if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(this.executableTask.getJob().getId(), this.executableTask.getJobInstanceSnapshot().getId(), "task execute start ...");
            }
            this.executeTask(this.executableTask, simpleJobProcessor);
        }
        catch (Throwable e) {
            logger.error("[SimpleTaskProcessor]: executeTask error, instanceId:" + this.executableTask.getJobInstanceSnapshot().getId(), e);
        }
        finally {
            this.status = 0;
            this.clientContext.getExecutor().getSimplePool().removeTask(this.executableTask);
        }
    }

    private void executeTask(ExecutableTask executableTask, SimpleJobProcessor simpleJobProcessor) {
        TaskSnapshot taskSnapshot = executableTask.getTaskSnapshot();
        if (null == simpleJobProcessor) {
            logger.error("[SimpleTaskProcessor]: jobProcessor is null, please check " + executableTask.getJob().getJobProcessor());
            if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId(), "jobProcessor is null, please check " + executableTask.getJob().getJobProcessor());
            }
            this.clientContext.getExecutor().acknowledge(taskSnapshot, 4, 0);
            return;
        }
        this.context.setTask(taskSnapshot);
        ProcessResult processResult = null;
        try {
            processResult = simpleJobProcessor.process(this.context);
        }
        catch (Throwable e) {
            logger.error("[SimpleTaskProcessor]: process error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
        }
        if (null == processResult) {
            logger.error("[SimpleTaskProcessor]: process error, processResult is null, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
            processResult = new ProcessResult(false);
        }
        this.handleRetryCount(taskSnapshot, processResult);
        this.clientContext.getExecutor().acknowledge(taskSnapshot, processResult.isSuccess() ? 3 : 4, processResult.getRetryCount());
        if ("JuShiTa".equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(executableTask.getJob().getId(), executableTask.getJobInstanceSnapshot().getId(), "task execute end, processResult:" + processResult);
        }
    }

    private void handleRetryCount(TaskSnapshot taskSnapshot, ProcessResult processResult) {
        if (processResult.isSuccess()) {
            processResult.setRetryCount(0);
            return;
        }
        if (this.executableTask.isCompensation()) {
            if (taskSnapshot.getRetryCount() > 0) {
                processResult.setRetryCount(taskSnapshot.getRetryCount() - 1);
            } else {
                processResult.setRetryCount(0);
            }
            return;
        }
        if (processResult.getRetryCount() > 100) {
            processResult.setRetryCount(100);
            return;
        }
    }

    public int getStatus() {
        return this.status;
    }
}

