/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.stop;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.client.executor.stop.processor.StopTaskProcessor;
import com.alibaba.dts.common.constants.Constants;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StopJob
implements Constants {
    private static final Log logger = LogFactory.getLog(StopJob.class);
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor executor = null;
    private final ClientContext clientContext;

    public StopJob(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.executor = new ThreadPoolExecutor(0, 30, 30000L, TimeUnit.MILLISECONDS, this.queue, new ThreadFactory(){
            int index = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                ++this.index;
                return new Thread(runnable, "DTS-StopJobProcessor-" + this.index);
            }
        });
    }

    public void stopTask(long jobId, long jobInstanceId) {
        StopJobProcessor stopJobProcessor = this.clientContext.getClientConfig().getStopJobProcessor();
        if (null == stopJobProcessor) {
            return;
        }
        try {
            this.executor.execute(new StopTaskProcessor(jobId, jobInstanceId, stopJobProcessor));
        }
        catch (Throwable e) {
            logger.error((Object)("[StopJob]: execute error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId), e);
        }
    }
}

