/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.remoting.processor.ClientRequestProcessor;
import com.alibaba.dts.client.remoting.proxy.ClientInvocationHandler;
import com.alibaba.dts.client.remoting.timer.DtsClientHeartBeatTimer;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.exception.RemotingConnectException;
import com.alibaba.dts.common.exception.RemotingSendRequestException;
import com.alibaba.dts.common.exception.RemotingTimeoutException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.remoting.netty.NettyClientConfig;
import com.alibaba.dts.common.remoting.netty.NettyRemotingClient;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.service.ServerService;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.io.netty.channel.Channel;
import com.alibaba.middleware.innerlog.Logger;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.util.CollectionUtils;

public class ClientRemoting
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ClientRemoting.class);
    private NettyRemotingClient client = null;
    private ScheduledExecutorService dtsTimerService = Executors.newScheduledThreadPool(1, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable runnable) {
            ++this.index;
            return new Thread(runnable, "DTS-heart-beat-thread-" + this.index);
        }
    });
    private final InvocationHandler invocationHandler;
    private final ServerService serverService;
    private volatile List<String> serverListCache;
    private final ClientContext clientContext;

    public ClientRemoting(ClientContext clientContext) {
        this.clientContext = clientContext;
        this.invocationHandler = new ClientInvocationHandler(this.clientContext);
        this.serverService = this.proxyInterface(ServerService.class);
    }

    public void init() throws InitException {
        this.initRemotingClient();
        this.initConnection();
        this.initHeartBeatTimer();
    }

    private void initRemotingClient() throws InitException {
        NettyClientConfig config = new NettyClientConfig();
        ClientRequestProcessor processor = new ClientRequestProcessor(this.clientContext);
        this.client = new NettyRemotingClient(config);
        this.client.registerProcessor(0, processor, Executors.newFixedThreadPool(this.clientContext.getClientConfig().getRemotingThreads(), new ThreadFactory(){
            int index = 0;

            @Override
            public Thread newThread(Runnable runnable) {
                ++this.index;
                Thread thread = new Thread(runnable, "DTS-remoting-thread-" + this.index);
                thread.setPriority(10);
                return thread;
            }
        }));
        try {
            this.client.start();
        }
        catch (Throwable e) {
            throw new InitException("[ClientRemoting]: initRemotingClient error", e);
        }
    }

    private void initConnection() throws InitException {
        List<String> serverList = this.getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.warn("[ClientRemoting]: initConnection error, serverList is empty");
            return;
        }
        for (String server : serverList) {
            this.connectServer(server);
        }
    }

    public void connectServer(String server) throws InitException {
        long connectTime = System.currentTimeMillis();
        this.clientContext.getClientConfig().setConnectTime(connectTime);
        this.clientContext.getClientConfig().setSignature(this.clientContext.getSecurityCheck().getSignatureStr(connectTime));
        if ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) && this.clientContext.getClientConfig().getAccessKey() == null) {
            throw new InitException("[ClientRemoting]: AK  is Null!");
        }
        InvocationContext.setRemoteMachine(new RemoteMachine(server));
        Result<Boolean> connectResult = this.serverService.connect(StringUtil.isBlank(this.clientContext.getClientConfig().getAccessKey()) ? "NULL" : this.clientContext.getClientConfig().getAccessKey());
        if (null == connectResult) {
            logger.warn("[ClientRemoting]: connectServer failed, connectResult is null, machineGroup:" + this.clientContext.getClientConfig().getGroupId() + ", server:" + server);
            return;
        }
        if (!connectResult.getData().booleanValue()) {
            logger.warn("[ClientRemoting]: connectServer failed, connectResult:" + connectResult.toString() + ", machineGroup:" + this.clientContext.getClientConfig().getGroupId() + ", server:" + server + ",resp:" + connectResult.getResultCode().getInformation());
            throw new InitException("[ClientRemoting]: connectServer error," + connectResult.getResultCode().getInformation());
        }
    }

    public List<String> getServerList() {
        if (CollectionUtils.isEmpty(this.serverListCache)) {
            this.serverListCache = this.clientContext.getZookeeper().getServerList();
        }
        return this.serverListCache;
    }

    private void initHeartBeatTimer() throws InitException {
        try {
            this.dtsTimerService.scheduleAtFixedRate(new DtsClientHeartBeatTimer(this.clientContext), this.clientContext.getClientConfig().getHeartBeatIntervalTime(), this.clientContext.getClientConfig().getHeartBeatIntervalTime(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new InitException("[ClientRemoting]: initHeartBeatTimer error, heartBeatIntervalTime:" + this.clientContext.getClientConfig().getHeartBeatIntervalTime(), e);
        }
        logger.warn("[ClientRemoting]: initHeartBeatTimer success, heartBeatIntervalTime:" + this.clientContext.getClientConfig().getHeartBeatIntervalTime());
    }

    public <T> T proxyInterface(Class<T> interfaceClass) {
        return this.clientContext.getProxyService().proxyInterface(interfaceClass, this.invocationHandler);
    }

    public Channel getAndCreateChannel(String addr) throws InterruptedException {
        return this.client.getAndCreateChannel(addr);
    }

    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        return this.client.invokeSync(addr, request, timeoutMillis);
    }

    public AtomicLong getCounter(ConcurrentHashMap<String, AtomicLong> heartBeatCounter, String key) {
        AtomicLong existCounter;
        AtomicLong counter = heartBeatCounter.get(key);
        if (null == counter && (existCounter = heartBeatCounter.putIfAbsent(key, counter = new AtomicLong(0L))) != null) {
            counter = existCounter;
        }
        return counter;
    }

    public void setServerListCache(List<String> serverListCache) {
        this.serverListCache = serverListCache;
    }
}

