/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting.timer;

import com.alibaba.dts.client.context.ClientContext;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class DtsClientHeartBeatTimer
extends TimerTask {
    private static final Log logger = LogFactory.getLog(DtsClientHeartBeatTimer.class);
    private final ClientContext clientContext;

    public DtsClientHeartBeatTimer(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public void run() {
        try {
            List<String> serverList = this.clientContext.getZookeeper().getServerList();
            if (CollectionUtils.isEmpty(serverList)) {
                logger.warn((Object)("[DtsClientHeartBeatTimer]: serverList is empty, clientConfig:" + this.clientContext.getClientConfig().toString()));
                return;
            }
            this.clientContext.getClientRemoting().setServerListCache(serverList);
            for (String server : serverList) {
                try {
                    this.clientContext.getClientRemoting().connectServer(server);
                }
                catch (Throwable e) {
                    logger.error((Object)("[DtsClientHeartBeatTimer]: connectServer error, server:" + server + ", clientConfig:" + this.clientContext.getClientConfig().toString()), e);
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)("[DtsClientHeartBeatTimer]: run error, clientConfig:" + this.clientContext.getClientConfig().toString()), e);
        }
    }
}

