/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.service;

import com.alibaba.dts.client.context.ClientContext;
import com.alibaba.dts.client.service.JobRunningException;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.ExecuteLogger;
import com.alibaba.dts.common.domain.JobInstanceInfo;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.service.ClientService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientServiceImpl
implements ClientService,
Constants {
    private static final Log logger = LogFactory.getLog(ClientServiceImpl.class);
    private final ClientContext clientContext;

    public ClientServiceImpl(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public Result<String> heartBeatCheck() {
        return new Result<String>("I am alive !", ResultCode.SUCCESS);
    }

    @Override
    public Result<String> heartBeatCheckJobInstance(int jobType, long jobId, long jobInstanceId) {
        return this.clientContext.getExecutor().heartBeatCheckJobInstance(jobType, jobId, jobInstanceId);
    }

    @Override
    public Result<Boolean> executeTask(ExecutableTask executableTask) {
        return this.clientContext.getExecutor().executeTask(executableTask);
    }

    @Override
    public Result<Boolean> activeTask(ExecutableTask executableTask) {
        return this.clientContext.getExecutor().activeTask(executableTask);
    }

    @Override
    public Result<Boolean> stopTask(int jobType, long jobId, long jobInstanceId) {
        return this.clientContext.getExecutor().stopTask(jobType, jobId, jobInstanceId);
    }

    @Override
    public Result<Boolean> forceStopTask(ExecutableTask executableTask) {
        return this.clientContext.getExecutor().forceStopTask(executableTask);
    }

    @Override
    public Result<Boolean> push(int jobType, long jobId, long jobInstanceId, TaskSnapshot taskSnapshot) {
        return this.clientContext.getExecutor().push(jobType, jobId, jobInstanceId, taskSnapshot);
    }

    @Override
    public Result<Boolean> releaseCompleteTask(ExecutableTask executableTask) {
        return this.clientContext.getExecutor().releaseCompleteTask(executableTask);
    }

    @Override
    public Result<ExecuteLogger> getExceptionInfo(JobInstanceInfo jobInstance) {
        ExecuteLogger executeLogger = new ExecuteLogger();
        if (jobInstance == null) {
            return new Result<Object>(null, ResultCode.FAILURE);
        }
        JobRunningException jobRunningException = JobRunningStateManager.getManageHandler().getJobRunningException(jobInstance.getJobInstanceId());
        if (jobRunningException == null) {
            return new Result<Object>(null, ResultCode.FAILURE);
        }
        executeLogger.setContents(jobRunningException.getThrowableStrRep());
        executeLogger.setHappenTime(jobRunningException.getUpdateTime());
        return new Result<ExecuteLogger>(executeLogger, ResultCode.SUCCESS);
    }
}

