/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.domain;

import java.math.BigDecimal;

public class ProgressBar {
    private String name;
    private String instanceId;
    private long totalAmount;
    private long initAmount;
    private long queueAmount;
    private long startAmount;
    private long successAmount;
    private long failureAmount;
    private long foundAmount;

    public ProgressBar() {
    }

    public ProgressBar(String name, long totalAmount, long initAmount, long queueAmount, long startAmount, long successAmount, long failureAmount, long foundAmount) {
        this.name = name;
        this.totalAmount = totalAmount;
        this.initAmount = initAmount;
        this.queueAmount = queueAmount;
        this.startAmount = startAmount;
        this.successAmount = successAmount;
        this.failureAmount = failureAmount;
        this.foundAmount = foundAmount;
    }

    public String parsePercentRate() {
        double t = 0.0;
        if (this.totalAmount != 0L) {
            double percentRate = (double)(this.successAmount + this.failureAmount + this.foundAmount) / (double)this.totalAmount;
            BigDecimal bg = new BigDecimal(percentRate);
            t = bg.setScale(4, 4).doubleValue();
        }
        return t * 100.0 + "%";
    }

    public double parseProcessValue() {
        if (this.totalAmount != 0L) {
            double percentRate = (double)(this.successAmount + this.failureAmount + this.foundAmount) / (double)this.totalAmount;
            BigDecimal bg = new BigDecimal(percentRate);
            return bg.setScale(4, 4).doubleValue();
        }
        return 0.0;
    }

    public double errorRate() {
        if (this.totalAmount != 0L) {
            double percentRate = (double)(this.failureAmount + this.foundAmount) / (double)this.totalAmount;
            BigDecimal bg = new BigDecimal(percentRate);
            return bg.setScale(4, 4).doubleValue();
        }
        return 0.0;
    }

    public double successRate() {
        if (this.totalAmount != 0L) {
            double percentRate = (double)this.successAmount / (double)this.totalAmount;
            BigDecimal bg = new BigDecimal(percentRate);
            return bg.setScale(4, 4).doubleValue();
        }
        return 0.0;
    }

    public long getProcessCount() {
        return this.successAmount + this.failureAmount + this.foundAmount;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(long totalAmount) {
        this.totalAmount = totalAmount;
    }

    public long getInitAmount() {
        return this.initAmount;
    }

    public void setInitAmount(long initAmount) {
        this.initAmount = initAmount;
    }

    public long getQueueAmount() {
        return this.queueAmount;
    }

    public void setQueueAmount(long queueAmount) {
        this.queueAmount = queueAmount;
    }

    public long getStartAmount() {
        return this.startAmount;
    }

    public void setStartAmount(long startAmount) {
        this.startAmount = startAmount;
    }

    public long getSuccessAmount() {
        return this.successAmount;
    }

    public void setSuccessAmount(long successAmount) {
        this.successAmount = successAmount;
    }

    public long getFailureAmount() {
        return this.failureAmount;
    }

    public void setFailureAmount(long failureAmount) {
        this.failureAmount = failureAmount;
    }

    public long getFoundAmount() {
        return this.foundAmount;
    }

    public void setFoundAmount(long foundAmount) {
        this.foundAmount = foundAmount;
    }

    public String toString() {
        return "ProgressBar [name=" + this.name + ", totalAmount=" + this.totalAmount + ", initAmount=" + this.initAmount + ", queueAmount=" + this.queueAmount + ", startAmount=" + this.startAmount + ", successAmount=" + this.successAmount + ", failureAmount=" + this.failureAmount + ", foundAmount=" + this.foundAmount + "]";
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }
}

