/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.parser.deserializer;

import com.alibaba.dts.common.fastjson.JSON;
import com.alibaba.dts.common.fastjson.JSONException;
import com.alibaba.dts.common.fastjson.JSONObject;
import com.alibaba.dts.common.fastjson.parser.DefaultJSONParser;
import com.alibaba.dts.common.fastjson.parser.Feature;
import com.alibaba.dts.common.fastjson.parser.JSONLexer;
import com.alibaba.dts.common.fastjson.parser.JSONToken;
import com.alibaba.dts.common.fastjson.parser.ParseContext;
import com.alibaba.dts.common.fastjson.parser.ParserConfig;
import com.alibaba.dts.common.fastjson.parser.deserializer.FieldDeserializer;
import com.alibaba.dts.common.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.dts.common.fastjson.serializer.FilterUtils;
import com.alibaba.dts.common.fastjson.util.DeserializeBeanInfo;
import com.alibaba.dts.common.fastjson.util.FieldInfo;
import com.alibaba.dts.common.fastjson.util.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public class JavaBeanDeserializer
implements ObjectDeserializer {
    private final Map<String, FieldDeserializer> feildDeserializerMap = new IdentityHashMap<String, FieldDeserializer>();
    private final List<FieldDeserializer> fieldDeserializers = new ArrayList<FieldDeserializer>();
    private final List<FieldDeserializer> sortedFieldDeserializers = new ArrayList<FieldDeserializer>();
    private final Class<?> clazz;
    private DeserializeBeanInfo beanInfo;

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz) {
        this(config, clazz, clazz);
    }

    public JavaBeanDeserializer(ParserConfig config, Class<?> clazz, Type type) {
        this.clazz = clazz;
        this.beanInfo = DeserializeBeanInfo.computeSetters(clazz, type);
        for (FieldInfo fieldInfo : this.beanInfo.getFieldList()) {
            this.addFieldDeserializer(config, clazz, fieldInfo);
        }
        for (FieldInfo fieldInfo : this.beanInfo.getSortedFieldList()) {
            FieldDeserializer fieldDeserializer = this.feildDeserializerMap.get(fieldInfo.getName().intern());
            this.sortedFieldDeserializers.add(fieldDeserializer);
        }
    }

    public Map<String, FieldDeserializer> getFieldDeserializerMap() {
        return this.feildDeserializerMap;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    private void addFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        String interName = fieldInfo.getName().intern();
        FieldDeserializer fieldDeserializer = this.createFieldDeserializer(mapping, clazz, fieldInfo);
        this.feildDeserializerMap.put(interName, fieldDeserializer);
        this.fieldDeserializers.add(fieldDeserializer);
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        return mapping.createFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public Object createInstance(DefaultJSONParser parser, Type type) {
        Object object;
        if (type instanceof Class && this.clazz.isInterface()) {
            Class clazz = (Class)type;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            JSONObject obj = new JSONObject();
            Object proxy = Proxy.newProxyInstance(loader, new Class[]{clazz}, (InvocationHandler)obj);
            return proxy;
        }
        if (this.beanInfo.getDefaultConstructor() == null) {
            return null;
        }
        try {
            Constructor<?> constructor = this.beanInfo.getDefaultConstructor();
            object = constructor.getParameterTypes().length == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(parser.getContext().getObject());
        }
        catch (Exception e) {
            throw new JSONException("create instance error, class " + this.clazz.getName(), e);
        }
        if (parser.isEnabled(Feature.InitStringFieldAsEmpty)) {
            for (FieldInfo fieldInfo : this.beanInfo.getFieldList()) {
                if (fieldInfo.getFieldClass() != String.class) continue;
                try {
                    fieldInfo.set(object, "");
                }
                catch (Exception e) {
                    throw new JSONException("create instance error, class " + this.clazz.getName(), e);
                }
            }
        }
        return object;
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        return this.deserialze(parser, type, fieldName, null);
    }

    public <T> T deserialzeArrayMapping(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() != 14) {
            throw new JSONException("error");
        }
        object = this.createInstance(parser, type);
        int size = this.sortedFieldDeserializers.size();
        for (int i = 0; i < size; ++i) {
            char seperator = i == size - 1 ? (char)']' : ',';
            FieldDeserializer fieldDeser = this.sortedFieldDeserializers.get(i);
            Class<?> fieldClass = fieldDeser.getFieldClass();
            if (fieldClass == Integer.TYPE) {
                int value = lexer.scanInt(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == String.class) {
                String value = lexer.scanString(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass == Long.TYPE) {
                long value = lexer.scanLong(seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            if (fieldClass.isEnum()) {
                Enum<?> value = lexer.scanEnum(fieldClass, parser.getSymbolTable(), seperator);
                fieldDeser.setValue(object, value);
                continue;
            }
            lexer.nextToken(14);
            Object value = parser.parseObject(fieldDeser.getFieldType());
            fieldDeser.setValue(object, value);
            if (seperator == ']') {
                if (lexer.token() != 15) {
                    throw new JSONException("syntax error");
                }
                lexer.nextToken(16);
                continue;
            }
            if (seperator != 44 || lexer.token() == 16) continue;
            throw new JSONException("syntax error");
        }
        lexer.nextToken(16);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName, Object object) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken(16);
            return null;
        }
        ParseContext context = parser.getContext();
        if (object != null && context != null) {
            context = context.getParentContext();
        }
        ParseContext childContext = null;
        try {
            Object key;
            HashMap fieldValues;
            block52: {
                fieldValues = null;
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    if (object == null) {
                        object = this.createInstance(parser, type);
                    }
                    Object object2 = object;
                    return (T)object2;
                }
                if (lexer.token() == 14 && lexer.isEnabled(Feature.SupportArrayToBean)) {
                    T t = this.deserialzeArrayMapping(parser, type, fieldName, object);
                    return t;
                }
                if (lexer.token() != 12 && lexer.token() != 16) {
                    StringBuffer buf = new StringBuffer().append("syntax error, expect {, actual ").append(lexer.tokenName()).append(", pos ").append(lexer.pos());
                    if (fieldName instanceof String) {
                        buf.append(", fieldName ").append(fieldName);
                    }
                    throw new JSONException(buf.toString());
                }
                if (parser.getResolveStatus() == 2) {
                    parser.setResolveStatus(0);
                }
                while (true) {
                    boolean match;
                    if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                        if (lexer.token() == 13) {
                            lexer.nextToken(16);
                            break block52;
                        }
                        if (lexer.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                    }
                    if ("$ref" == key) {
                        Object ref;
                        lexer.nextTokenWithColon(4);
                        if (lexer.token() == 4) {
                            ref = lexer.stringVal();
                            if ("@".equals(ref)) {
                                object = context.getObject();
                            } else if ("..".equals(ref)) {
                                ParseContext parentContext = context.getParentContext();
                                if (parentContext.getObject() != null) {
                                    object = parentContext.getObject();
                                } else {
                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(parentContext, (String)ref));
                                    parser.setResolveStatus(1);
                                }
                            } else if ("$".equals(ref)) {
                                ParseContext rootContext = context;
                                while (rootContext.getParentContext() != null) {
                                    rootContext = rootContext.getParentContext();
                                }
                                if (rootContext.getObject() != null) {
                                    object = rootContext.getObject();
                                } else {
                                    parser.addResolveTask(new DefaultJSONParser.ResolveTask(rootContext, (String)ref));
                                    parser.setResolveStatus(1);
                                }
                            } else {
                                parser.addResolveTask(new DefaultJSONParser.ResolveTask(context, (String)ref));
                                parser.setResolveStatus(1);
                            }
                        } else {
                            throw new JSONException("illegal ref, " + JSONToken.name(lexer.token()));
                        }
                        lexer.nextToken(13);
                        if (lexer.token() != 13) {
                            throw new JSONException("illegal ref");
                        }
                        lexer.nextToken(16);
                        parser.setContext(context, object, fieldName);
                        ref = object;
                        return (T)ref;
                    }
                    if (JSON.DEFAULT_TYPE_KEY == key) {
                        lexer.nextTokenWithColon(4);
                        if (lexer.token() == 4) {
                            String typeName = lexer.stringVal();
                            lexer.nextToken(16);
                            if (type instanceof Class && typeName.equals(((Class)type).getName())) {
                                if (lexer.token() != 13) continue;
                                lexer.nextToken();
                                break block52;
                            }
                            Class<?> userType = TypeUtils.loadClass(typeName);
                            ObjectDeserializer deserizer = parser.getConfig().getDeserializer(userType);
                            Object t = deserizer.deserialze(parser, userType, fieldName);
                            return t;
                        }
                        throw new JSONException("syntax error");
                    }
                    if (object == null && fieldValues == null) {
                        object = this.createInstance(parser, type);
                        if (object == null) {
                            fieldValues = new HashMap(this.fieldDeserializers.size());
                        }
                        childContext = parser.setContext(context, object, fieldName);
                    }
                    if (!(match = this.parseField(parser, (String)key, object, type, fieldValues))) {
                        if (lexer.token() != 13) continue;
                        lexer.nextToken();
                        break block52;
                    }
                    if (lexer.token() == 16) continue;
                    if (lexer.token() == 13) {
                        lexer.nextToken(16);
                        break block52;
                    }
                    if (lexer.token() == 18 || lexer.token() == 1) break;
                }
                throw new JSONException("syntax error, unexpect token " + JSONToken.name(lexer.token()));
            }
            if (object == null) {
                if (fieldValues == null) {
                    object = this.createInstance(parser, type);
                    if (childContext == null) {
                        childContext = parser.setContext(context, object, fieldName);
                    }
                    key = object;
                    return (T)key;
                }
                List<FieldInfo> fieldInfoList = this.beanInfo.getFieldList();
                int size = fieldInfoList.size();
                Object[] params = new Object[size];
                for (int i = 0; i < size; ++i) {
                    FieldInfo fieldInfo = fieldInfoList.get(i);
                    params[i] = fieldValues.get(fieldInfo.getName());
                }
                if (this.beanInfo.getCreatorConstructor() != null) {
                    try {
                        object = this.beanInfo.getCreatorConstructor().newInstance(params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create instance error, " + this.beanInfo.getCreatorConstructor().toGenericString(), e);
                    }
                }
                if (this.beanInfo.getFactoryMethod() != null) {
                    try {
                        object = this.beanInfo.getFactoryMethod().invoke(null, params);
                    }
                    catch (Exception e) {
                        throw new JSONException("create factory method error, " + this.beanInfo.getFactoryMethod().toString(), e);
                    }
                }
            }
            Object object3 = object;
            return (T)object3;
        }
        finally {
            if (childContext != null) {
                childContext.setObject(object);
            }
            parser.setContext(context);
        }
    }

    public boolean parseField(DefaultJSONParser parser, String key, Object object, Type objectType, Map<String, Object> fieldValues) {
        JSONLexer lexer = parser.getLexer();
        FieldDeserializer fieldDeserializer = this.feildDeserializerMap.get(key);
        if (fieldDeserializer == null) {
            for (Map.Entry<String, FieldDeserializer> entry : this.feildDeserializerMap.entrySet()) {
                if (!entry.getKey().equalsIgnoreCase(key)) continue;
                fieldDeserializer = entry.getValue();
                break;
            }
        }
        if (fieldDeserializer == null) {
            this.parseExtra(parser, object, key);
            return false;
        }
        lexer.nextTokenWithColon(fieldDeserializer.getFastMatchToken());
        fieldDeserializer.parseField(parser, object, objectType, fieldValues);
        return true;
    }

    void parseExtra(DefaultJSONParser parser, Object object, String key) {
        JSONLexer lexer = parser.getLexer();
        if (!lexer.isEnabled(Feature.IgnoreNotMatch)) {
            throw new JSONException("setter not found, class " + this.clazz.getName() + ", property " + key);
        }
        lexer.nextTokenWithColon();
        Type type = FilterUtils.getExtratype(parser, object, key);
        Object value = type == null ? parser.parse() : parser.parseObject(type);
        FilterUtils.processExtra(parser, object, key, value);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

