/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.serializer;

import com.alibaba.dts.common.fastjson.parser.DefaultJSONParser;
import com.alibaba.dts.common.fastjson.parser.JSONLexer;
import com.alibaba.dts.common.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.dts.common.fastjson.serializer.JSONSerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectSerializer;
import com.alibaba.dts.common.fastjson.serializer.SerializeWriter;
import com.alibaba.dts.common.fastjson.serializer.SerializerFeature;
import com.alibaba.dts.common.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class BigDecimalCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        BigDecimal val = (BigDecimal)object;
        out.write(val.toString());
        if (out.isEnabled(SerializerFeature.WriteClassName) && fieldType != BigDecimal.class && val.scale() == 0) {
            out.write('.');
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return BigDecimalCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 2) {
            long val = lexer.longValue();
            lexer.nextToken(16);
            return (T)new BigDecimal(val);
        }
        if (lexer.token() == 3) {
            BigDecimal val = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)val;
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)TypeUtils.castToBigDecimal(value);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

