/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.serializer;

import com.alibaba.dts.common.fastjson.JSON;
import com.alibaba.dts.common.fastjson.JSONException;
import com.alibaba.dts.common.fastjson.serializer.FieldSerializer;
import com.alibaba.dts.common.fastjson.serializer.FilterUtils;
import com.alibaba.dts.common.fastjson.serializer.JSONSerializer;
import com.alibaba.dts.common.fastjson.serializer.NumberFieldSerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectFieldSerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectSerializer;
import com.alibaba.dts.common.fastjson.serializer.SerialContext;
import com.alibaba.dts.common.fastjson.serializer.SerializeWriter;
import com.alibaba.dts.common.fastjson.serializer.SerializerFeature;
import com.alibaba.dts.common.fastjson.util.FieldInfo;
import com.alibaba.dts.common.fastjson.util.TypeUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;
    private final FieldSerializer[] sortedGetters;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        for (String alias : aliasList) {
            aliasMap.put(alias, alias);
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(clazz, aliasMap, false);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
        getterList = new ArrayList();
        fieldInfoList = TypeUtils.computeGetters(clazz, aliasMap, true);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.sortedGetters = getterList.toArray(new FieldSerializer[getterList.size()]);
    }

    protected boolean isWriteClassName(JSONSerializer serializer, Object obj, Type fieldType, Object fieldName) {
        return serializer.isWriteClassName(fieldType, obj);
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        if (serializer.containsReference(object)) {
            this.writeReference(serializer, object);
            return;
        }
        FieldSerializer[] getters = out.isEnabled(SerializerFeature.SortField) ? this.sortedGetters : this.getters;
        SerialContext parent = serializer.getContext();
        serializer.setContext(parent, object, fieldName);
        boolean writeAsArray = serializer.isWriteAsArray(object, fieldType);
        try {
            Class<?> objClass;
            char startSeperator = writeAsArray ? (char)'[' : '{';
            char endSeperator = writeAsArray ? (char)']' : '}';
            out.append(startSeperator);
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.incrementIndent();
                serializer.println();
            }
            boolean commaFlag = false;
            if (this.isWriteClassName(serializer, object, fieldType, fieldName) && (objClass = object.getClass()) != fieldType) {
                out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                serializer.write(object.getClass());
                commaFlag = true;
            }
            char seperator = commaFlag ? (char)',' : '\u0000';
            char newSeperator = FilterUtils.writeBefore(serializer, object, seperator);
            commaFlag = newSeperator == ',';
            for (int i = 0; i < getters.length; ++i) {
                Field field;
                FieldSerializer fieldSerializer = getters[i];
                if (serializer.isEnabled(SerializerFeature.SkipTransientField) && (field = fieldSerializer.getField()) != null && Modifier.isTransient(field.getModifiers()) || !FilterUtils.applyName(serializer, object, fieldSerializer.getName())) continue;
                Object propertyValue = fieldSerializer.getPropertyValue(object);
                if (!FilterUtils.apply(serializer, object, fieldSerializer.getName(), propertyValue)) continue;
                String key = FilterUtils.processKey(serializer, object, fieldSerializer.getName(), propertyValue);
                Object originalValue = propertyValue;
                propertyValue = FilterUtils.processValue(serializer, object, fieldSerializer.getName(), propertyValue);
                if (propertyValue == null && !writeAsArray && !fieldSerializer.isWriteNull() && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
                if (commaFlag) {
                    out.append(',');
                    if (out.isEnabled(SerializerFeature.PrettyFormat)) {
                        serializer.println();
                    }
                }
                if (key != fieldSerializer.getName()) {
                    if (!writeAsArray) {
                        out.writeFieldName(key);
                    }
                    serializer.write(propertyValue);
                } else if (originalValue != propertyValue) {
                    if (!writeAsArray) {
                        fieldSerializer.writePrefix(serializer);
                    }
                    serializer.write(propertyValue);
                } else if (!writeAsArray) {
                    fieldSerializer.writeProperty(serializer, propertyValue);
                } else {
                    fieldSerializer.writeValue(serializer, propertyValue);
                }
                commaFlag = true;
            }
            FilterUtils.writeAfter(serializer, object, commaFlag ? (char)',' : '\u0000');
            if (getters.length > 0 && out.isEnabled(SerializerFeature.PrettyFormat)) {
                serializer.decrementIdent();
                serializer.println();
            }
            out.append(endSeperator);
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
        finally {
            serializer.setContext(parent);
        }
    }

    public void writeReference(JSONSerializer serializer, Object object) {
        serializer.writeReference(object);
    }

    public FieldSerializer createFieldSerializer(FieldInfo fieldInfo) {
        Class<?> clazz = fieldInfo.getFieldClass();
        if (clazz == Number.class) {
            return new NumberFieldSerializer(fieldInfo);
        }
        return new ObjectFieldSerializer(fieldInfo);
    }
}

