/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.serializer;

import com.alibaba.dts.common.fastjson.annotation.JSONField;
import com.alibaba.dts.common.fastjson.serializer.FieldSerializer;
import com.alibaba.dts.common.fastjson.serializer.JSONSerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectSerializer;
import com.alibaba.dts.common.fastjson.serializer.SerializerFeature;
import com.alibaba.dts.common.fastjson.util.FieldInfo;
import java.util.Collection;

public class ObjectFieldSerializer
extends FieldSerializer {
    private ObjectSerializer fieldSerializer;
    private Class<?> runtimeFieldClass;
    private String format;
    private boolean writeNumberAsZero = false;
    boolean writeNullStringAsEmpty = false;
    boolean writeNullBooleanAsFalse = false;
    boolean writeNullListAsEmpty = false;
    boolean writeEnumUsingToString = false;

    public ObjectFieldSerializer(FieldInfo fieldInfo) {
        super(fieldInfo);
        JSONField annotation = fieldInfo.getAnnotation(JSONField.class);
        if (annotation != null) {
            this.format = annotation.format();
            if (this.format.trim().length() == 0) {
                this.format = null;
            }
            for (SerializerFeature feature : annotation.serialzeFeatures()) {
                if (feature == SerializerFeature.WriteNullNumberAsZero) {
                    this.writeNumberAsZero = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullStringAsEmpty) {
                    this.writeNullStringAsEmpty = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullBooleanAsFalse) {
                    this.writeNullBooleanAsFalse = true;
                    continue;
                }
                if (feature == SerializerFeature.WriteNullListAsEmpty) {
                    this.writeNullListAsEmpty = true;
                    continue;
                }
                if (feature != SerializerFeature.WriteEnumUsingToString) continue;
                this.writeEnumUsingToString = true;
            }
        }
    }

    @Override
    public void writeProperty(JSONSerializer serializer, Object propertyValue) throws Exception {
        this.writePrefix(serializer);
        this.writeValue(serializer, propertyValue);
    }

    @Override
    public void writeValue(JSONSerializer serializer, Object propertyValue) throws Exception {
        if (this.format != null) {
            serializer.writeWithFormat(propertyValue, this.format);
            return;
        }
        if (this.fieldSerializer == null) {
            this.runtimeFieldClass = propertyValue == null ? this.fieldInfo.getFieldClass() : propertyValue.getClass();
            this.fieldSerializer = serializer.getObjectWriter(this.runtimeFieldClass);
        }
        if (propertyValue == null) {
            if (this.writeNumberAsZero && Number.class.isAssignableFrom(this.runtimeFieldClass)) {
                serializer.getWriter().write('0');
                return;
            }
            if (this.writeNullStringAsEmpty && String.class == this.runtimeFieldClass) {
                serializer.getWriter().write("\"\"");
                return;
            }
            if (this.writeNullBooleanAsFalse && Boolean.class == this.runtimeFieldClass) {
                serializer.getWriter().write("false");
                return;
            }
            if (this.writeNullListAsEmpty && Collection.class.isAssignableFrom(this.runtimeFieldClass)) {
                serializer.getWriter().write("[]");
                return;
            }
            this.fieldSerializer.write(serializer, null, this.fieldInfo.getName(), null);
            return;
        }
        if (this.writeEnumUsingToString && this.runtimeFieldClass.isEnum()) {
            serializer.getWriter().writeString(((Enum)propertyValue).name());
            return;
        }
        Class<?> valueClass = propertyValue.getClass();
        if (valueClass == this.runtimeFieldClass) {
            this.fieldSerializer.write(serializer, propertyValue, this.fieldInfo.getName(), this.fieldInfo.getFieldType());
            return;
        }
        ObjectSerializer valueSerializer = serializer.getObjectWriter(valueClass);
        valueSerializer.write(serializer, propertyValue, this.fieldInfo.getName(), this.fieldInfo.getFieldType());
    }
}

