/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.serializer;

import com.alibaba.dts.common.fastjson.JSON;
import com.alibaba.dts.common.fastjson.JSONException;
import com.alibaba.dts.common.fastjson.annotation.JSONType;
import com.alibaba.dts.common.fastjson.serializer.ASMSerializerFactory;
import com.alibaba.dts.common.fastjson.serializer.AppendableSerializer;
import com.alibaba.dts.common.fastjson.serializer.AtomicBooleanSerializer;
import com.alibaba.dts.common.fastjson.serializer.AtomicIntegerArrayCodec;
import com.alibaba.dts.common.fastjson.serializer.AtomicIntegerSerializer;
import com.alibaba.dts.common.fastjson.serializer.AtomicLongArrayCodec;
import com.alibaba.dts.common.fastjson.serializer.AtomicLongSerializer;
import com.alibaba.dts.common.fastjson.serializer.BigDecimalCodec;
import com.alibaba.dts.common.fastjson.serializer.BigIntegerCodec;
import com.alibaba.dts.common.fastjson.serializer.BooleanArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.BooleanCodec;
import com.alibaba.dts.common.fastjson.serializer.ByteArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.ByteSerializer;
import com.alibaba.dts.common.fastjson.serializer.CharArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.CharacterCodec;
import com.alibaba.dts.common.fastjson.serializer.CharsetCodec;
import com.alibaba.dts.common.fastjson.serializer.ClassSerializer;
import com.alibaba.dts.common.fastjson.serializer.ColorCodec;
import com.alibaba.dts.common.fastjson.serializer.CurrencyCodec;
import com.alibaba.dts.common.fastjson.serializer.DateFormatSerializer;
import com.alibaba.dts.common.fastjson.serializer.DoubleArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.DoubleSerializer;
import com.alibaba.dts.common.fastjson.serializer.FileCodec;
import com.alibaba.dts.common.fastjson.serializer.FloatArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.FloatCodec;
import com.alibaba.dts.common.fastjson.serializer.FontCodec;
import com.alibaba.dts.common.fastjson.serializer.InetAddressCodec;
import com.alibaba.dts.common.fastjson.serializer.InetSocketAddressCodec;
import com.alibaba.dts.common.fastjson.serializer.IntArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.IntegerCodec;
import com.alibaba.dts.common.fastjson.serializer.JavaBeanSerializer;
import com.alibaba.dts.common.fastjson.serializer.LocaleCodec;
import com.alibaba.dts.common.fastjson.serializer.LongArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.LongCodec;
import com.alibaba.dts.common.fastjson.serializer.ObjectArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectSerializer;
import com.alibaba.dts.common.fastjson.serializer.PatternCodec;
import com.alibaba.dts.common.fastjson.serializer.PointCodec;
import com.alibaba.dts.common.fastjson.serializer.RectangleCodec;
import com.alibaba.dts.common.fastjson.serializer.ReferenceCodec;
import com.alibaba.dts.common.fastjson.serializer.ShortArraySerializer;
import com.alibaba.dts.common.fastjson.serializer.ShortSerializer;
import com.alibaba.dts.common.fastjson.serializer.StringCodec;
import com.alibaba.dts.common.fastjson.serializer.TimeZoneCodec;
import com.alibaba.dts.common.fastjson.serializer.URICodec;
import com.alibaba.dts.common.fastjson.serializer.URLCodec;
import com.alibaba.dts.common.fastjson.serializer.UUIDCodec;
import com.alibaba.dts.common.fastjson.util.ASMUtils;
import com.alibaba.dts.common.fastjson.util.IdentityHashMap;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    private static final SerializeConfig globalInstance = new SerializeConfig();
    private boolean asm = !ASMUtils.isAndroid();
    private final ASMSerializerFactory asmFactory = new ASMSerializerFactory();
    private String typeKey = JSON.DEFAULT_TYPE_KEY;

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    public final ObjectSerializer createASMSerializer(Class<?> clazz) throws Exception {
        return this.asmFactory.createJavaBeanSerializer(clazz);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        JSONType annotation;
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return new JavaBeanSerializer(clazz);
        }
        boolean asm = this.asm;
        if (asm && this.asmFactory.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            asm = false;
        }
        if ((annotation = clazz.getAnnotation(JSONType.class)) != null && !annotation.asm()) {
            asm = false;
        }
        if (asm) {
            try {
                return this.createASMSerializer(clazz);
            }
            catch (ClassCastException e) {
                return new JavaBeanSerializer(clazz);
            }
            catch (Throwable e) {
                throw new JSONException("create asm serializer error, class " + clazz, e);
            }
        }
        return new JavaBeanSerializer(clazz);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asm = asmEnable;
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        this.put(Boolean.class, BooleanCodec.instance);
        this.put(Character.class, CharacterCodec.instance);
        this.put(Byte.class, ByteSerializer.instance);
        this.put(Short.class, ShortSerializer.instance);
        this.put(Integer.class, IntegerCodec.instance);
        this.put(Long.class, LongCodec.instance);
        this.put(Float.class, FloatCodec.instance);
        this.put(Double.class, DoubleSerializer.instance);
        this.put(BigDecimal.class, BigDecimalCodec.instance);
        this.put(BigInteger.class, BigIntegerCodec.instance);
        this.put(String.class, StringCodec.instance);
        this.put(byte[].class, ByteArraySerializer.instance);
        this.put(short[].class, ShortArraySerializer.instance);
        this.put(int[].class, IntArraySerializer.instance);
        this.put(long[].class, LongArraySerializer.instance);
        this.put(float[].class, FloatArraySerializer.instance);
        this.put(double[].class, DoubleArraySerializer.instance);
        this.put(boolean[].class, BooleanArraySerializer.instance);
        this.put(char[].class, CharArraySerializer.instance);
        this.put(Object[].class, ObjectArraySerializer.instance);
        this.put(Class.class, ClassSerializer.instance);
        this.put(SimpleDateFormat.class, DateFormatSerializer.instance);
        this.put(Locale.class, LocaleCodec.instance);
        this.put(Currency.class, CurrencyCodec.instance);
        this.put(TimeZone.class, TimeZoneCodec.instance);
        this.put(UUID.class, UUIDCodec.instance);
        this.put(InetAddress.class, InetAddressCodec.instance);
        this.put(Inet4Address.class, InetAddressCodec.instance);
        this.put(Inet6Address.class, InetAddressCodec.instance);
        this.put(InetSocketAddress.class, InetSocketAddressCodec.instance);
        this.put(File.class, FileCodec.instance);
        this.put(URI.class, URICodec.instance);
        this.put(URL.class, URLCodec.instance);
        this.put(Appendable.class, AppendableSerializer.instance);
        this.put(StringBuffer.class, AppendableSerializer.instance);
        this.put(StringBuilder.class, AppendableSerializer.instance);
        this.put(Pattern.class, PatternCodec.instance);
        this.put(Charset.class, CharsetCodec.instance);
        this.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        this.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        this.put(AtomicLong.class, AtomicLongSerializer.instance);
        this.put(AtomicReference.class, ReferenceCodec.instance);
        this.put(AtomicIntegerArray.class, AtomicIntegerArrayCodec.instance);
        this.put(AtomicLongArray.class, AtomicLongArrayCodec.instance);
        this.put(WeakReference.class, ReferenceCodec.instance);
        this.put(SoftReference.class, ReferenceCodec.instance);
        try {
            this.put(Class.forName("java.awt.Color"), ColorCodec.instance);
            this.put(Class.forName("java.awt.Font"), FontCodec.instance);
            this.put(Class.forName("java.awt.Point"), PointCodec.instance);
            this.put(Class.forName("java.awt.Rectangle"), RectangleCodec.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

