/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.serializer;

import com.alibaba.dts.common.fastjson.parser.DefaultJSONParser;
import com.alibaba.dts.common.fastjson.parser.JSONLexer;
import com.alibaba.dts.common.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.dts.common.fastjson.serializer.JSONSerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectSerializer;
import com.alibaba.dts.common.fastjson.serializer.SerializeWriter;
import com.alibaba.dts.common.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class StringCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static StringCodec instance = new StringCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        this.write(serializer, (String)object);
    }

    public void write(JSONSerializer serializer, String value) {
        SerializeWriter out = serializer.getWriter();
        if (value == null) {
            if (out.isEnabled(SerializerFeature.WriteNullStringAsEmpty)) {
                out.writeString("");
            } else {
                out.writeNull();
            }
            return;
        }
        out.writeString(value);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return StringCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)val;
        }
        if (lexer.token() == 2) {
            String val = lexer.numberString();
            lexer.nextToken(16);
            return (T)val;
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)value.toString();
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

