/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.serializer;

import com.alibaba.dts.common.fastjson.JSONException;
import com.alibaba.dts.common.fastjson.parser.DefaultJSONParser;
import com.alibaba.dts.common.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.dts.common.fastjson.serializer.JSONSerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;

public class URLCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final URLCodec instance = new URLCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        serializer.write(object.toString());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String url = (String)parser.parse();
        if (url == null) {
            return null;
        }
        try {
            return (T)new URL(url);
        }
        catch (MalformedURLException e) {
            throw new JSONException("create url error", e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

