/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.serializer;

import com.alibaba.dts.common.fastjson.parser.DefaultJSONParser;
import com.alibaba.dts.common.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.dts.common.fastjson.serializer.JSONSerializer;
import com.alibaba.dts.common.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.UUID;

public class UUIDCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final UUIDCodec instance = new UUIDCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        UUID uid = (UUID)object;
        serializer.write(uid.toString());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String name = (String)parser.parse();
        if (name == null) {
            return null;
        }
        return (T)UUID.fromString(name);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

