/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.fastjson.util;

import com.alibaba.dts.common.fastjson.parser.DefaultJSONParser;
import com.alibaba.dts.common.fastjson.parser.JSONLexer;
import com.alibaba.dts.common.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;

public class ASMUtils {
    public static boolean isAndroid(String vmName) {
        String lowerVMName = vmName.toLowerCase();
        return lowerVMName.contains("dalvik") || lowerVMName.contains("lemur");
    }

    public static boolean isAndroid() {
        return ASMUtils.isAndroid(System.getProperty("java.vm.name"));
    }

    public static String getDesc(Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            buf.append(ASMUtils.getDesc(types[i]));
        }
        buf.append(")");
        buf.append(ASMUtils.getDesc(method.getReturnType()));
        return buf.toString();
    }

    public static String getDesc(Class<?> returnType) {
        if (returnType.isPrimitive()) {
            return ASMUtils.getPrimitiveLetter(returnType);
        }
        if (returnType.isArray()) {
            return "[" + ASMUtils.getDesc(returnType.getComponentType());
        }
        return "L" + ASMUtils.getType(returnType) + ";";
    }

    public static String getType(Class<?> parameterType) {
        if (parameterType.isArray()) {
            return "[" + ASMUtils.getDesc(parameterType.getComponentType());
        }
        if (!parameterType.isPrimitive()) {
            String clsName = parameterType.getName();
            return clsName.replaceAll("\\.", "/");
        }
        return ASMUtils.getPrimitiveLetter(parameterType);
    }

    public static String getPrimitiveLetter(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    public static Type getMethodType(Class<?> clazz, String methodName) {
        try {
            Method method = clazz.getMethod(methodName, new Class[0]);
            return method.getGenericReturnType();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Type getFieldType(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return field.getGenericType();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void parseArray(Collection collection, ObjectDeserializer deser, DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken(16);
        }
        parser.accept(14, 14);
        int index = 0;
        while (true) {
            Object item = deser.deserialze(parser, type, index);
            collection.add(item);
            ++index;
            if (lexer.token() != 16) break;
            lexer.nextToken(14);
        }
        parser.accept(15, 16);
    }
}

