/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.logger;

import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.middleware.innerlog.LogConfigure;
import com.alibaba.middleware.innerlog.Logger;
import com.alibaba.middleware.innerlog.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SchedulerXLoggerFactory {
    private static final String SCHEDULERX_LOG_APP_KEY = "SCHEDULERX";
    private static String DEFAULT_LOGGER_NAME = "schedulerx-default";
    private static String EXECUTE_LOGGER_NAME = "schedulerx-execute";

    public static void initByClassResource(String classResource) {
        LoggerFactory.initByClassResource(classResource);
    }

    public static void initByFileSystem(String configFilePath) {
        LoggerFactory.initByClassResource(configFilePath);
    }

    public static synchronized void doConfigure(LogConfigure logConfigure) {
        LoggerFactory.doConfigure(logConfigure, SCHEDULERX_LOG_APP_KEY);
    }

    public static Logger getLogger(String logName) {
        return LoggerFactory.getLogger(logName, SCHEDULERX_LOG_APP_KEY);
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz, SCHEDULERX_LOG_APP_KEY);
    }

    public static Logger getLogger(Class<?> clazz, String defaultLogLevel, String executeLogLevel) {
        return LoggerFactory.getLogger(clazz, SCHEDULERX_LOG_APP_KEY);
    }

    public static void init() {
        LoggerFactory.doConfigure(new LogConfigure(){

            @Override
            public InputStream configure() {
                InputStream inputStream = SchedulerXLoggerFactory.class.getClassLoader().getResourceAsStream("inner-schedulerx-logback.xml");
                return inputStream;
            }
        }, SCHEDULERX_LOG_APP_KEY);
    }

    public static void initLogByLevel(final String defaultLogLevel, final String executeLogLevel) {
        LoggerFactory.doConfigure(new LogConfigure(){

            @Override
            public InputStream configure() {
                InputStream inputStream = SchedulerXLoggerFactory.class.getClassLoader().getResourceAsStream("inner-schedulerx-logback.xml");
                if (null != inputStream && StringUtils.isNotBlank(defaultLogLevel) && StringUtils.isNotBlank(executeLogLevel)) {
                    String configContext = 2.getStringFromInputStream(inputStream);
                    String newConfigContext = StringUtils.replace(configContext, "${defaultLogLevel}", defaultLogLevel).replace("${executeLogLevel}", executeLogLevel);
                    inputStream = new ByteArrayInputStream(newConfigContext.getBytes());
                }
                return inputStream;
            }
        }, SCHEDULERX_LOG_APP_KEY);
    }

    public static Logger getExecuteLogger() {
        return SchedulerXLoggerFactory.getLogger(EXECUTE_LOGGER_NAME);
    }
}

