/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.remoting.netty;

import com.alibaba.dts.common.domain.remoting.Pair;
import com.alibaba.dts.common.exception.RemotingConnectException;
import com.alibaba.dts.common.exception.RemotingSendRequestException;
import com.alibaba.dts.common.exception.RemotingTimeoutException;
import com.alibaba.dts.common.exception.RemotingTooMuchRequestException;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.remoting.ChannelEventListener;
import com.alibaba.dts.common.remoting.InvokeCallback;
import com.alibaba.dts.common.remoting.RPCHook;
import com.alibaba.dts.common.remoting.RemotingClient;
import com.alibaba.dts.common.remoting.netty.NettyClientConfig;
import com.alibaba.dts.common.remoting.netty.NettyDecoder;
import com.alibaba.dts.common.remoting.netty.NettyEncoder;
import com.alibaba.dts.common.remoting.netty.NettyEvent;
import com.alibaba.dts.common.remoting.netty.NettyEventType;
import com.alibaba.dts.common.remoting.netty.NettyRemotingAbstract;
import com.alibaba.dts.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.shade.io.netty.bootstrap.Bootstrap;
import com.alibaba.dts.shade.io.netty.channel.Channel;
import com.alibaba.dts.shade.io.netty.channel.ChannelDuplexHandler;
import com.alibaba.dts.shade.io.netty.channel.ChannelFuture;
import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;
import com.alibaba.dts.shade.io.netty.channel.ChannelInitializer;
import com.alibaba.dts.shade.io.netty.channel.ChannelOption;
import com.alibaba.dts.shade.io.netty.channel.ChannelPromise;
import com.alibaba.dts.shade.io.netty.channel.EventLoopGroup;
import com.alibaba.dts.shade.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.dts.shade.io.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.dts.shade.io.netty.channel.socket.SocketChannel;
import com.alibaba.dts.shade.io.netty.channel.socket.nio.NioSocketChannel;
import com.alibaba.dts.shade.io.netty.handler.timeout.IdleState;
import com.alibaba.dts.shade.io.netty.handler.timeout.IdleStateEvent;
import com.alibaba.dts.shade.io.netty.handler.timeout.IdleStateHandler;
import com.alibaba.dts.shade.io.netty.util.concurrent.DefaultEventExecutorGroup;
import com.alibaba.dts.shade.io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NettyRemotingClient
extends NettyRemotingAbstract
implements RemotingClient {
    private static final Log log = LogFactory.getLog(NettyRemotingClient.class);
    private static final long LockTimeoutMillis = 3000L;
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentHashMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final AtomicReference<List<String>> namesrvAddrList = new AtomicReference();
    private final AtomicReference<String> namesrvAddrChoosed = new AtomicReference();
    private final AtomicInteger namesrvIndex = new AtomicInteger(NettyRemotingClient.initValueIndex());
    private final Lock lockNamesrvChannel = new ReentrantLock();
    private final ExecutorService publicExecutor;
    private final ChannelEventListener channelEventListener;
    private RPCHook rpcHook;

    private static int initValueIndex() {
        Random r = new Random();
        return Math.abs(r.nextInt() % 999) % 999;
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig) {
        this(nettyClientConfig, null);
    }

    public NettyRemotingClient(NettyClientConfig nettyClientConfig, ChannelEventListener channelEventListener) {
        super(nettyClientConfig.getClientOnewaySemaphoreValue(), nettyClientConfig.getClientAsyncSemaphoreValue());
        this.nettyClientConfig = nettyClientConfig;
        this.channelEventListener = channelEventListener;
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        if (publicThreadNums <= 0) {
            publicThreadNums = 4;
        }
        this.publicExecutor = Executors.newFixedThreadPool(publicThreadNums, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupWorker = new NioEventLoopGroup(1, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, String.format("NettyClientSelector_%d", this.threadIndex.incrementAndGet()));
            }
        });
    }

    @Override
    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        Bootstrap handler = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, false)).option(ChannelOption.SO_SNDBUF, this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, this.nettyClientConfig.getClientSocketRcvBufSize())).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyRemotingClient.this.defaultEventExecutorGroup, new NettyEncoder(), new NettyDecoder(), new IdleStateHandler(0, 0, NettyRemotingClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnetManageHandler(), new NettyClientHandler());
            }
        });
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyRemotingClient.this.scanResponseTable();
                }
                catch (Exception e) {
                    log.error((Object)"scanResponseTable exception", (Throwable)e);
                }
            }
        }, 3000L, 1000L);
        if (this.channelEventListener != null) {
            this.nettyEventExecuter.start();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.timer.cancel();
            for (ChannelWrapper cw : this.channelTables.values()) {
                this.closeChannel(null, cw.getChannel());
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.nettyEventExecuter != null) {
                this.nettyEventExecuter.shutdown();
            }
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error((Object)"NettyRemotingClient shutdown exception, ", (Throwable)e);
        }
        if (this.publicExecutor != null) {
            try {
                this.publicExecutor.shutdown();
            }
            catch (Exception e) {
                log.error((Object)"NettyRemotingServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    public Channel getAndCreateChannel(String addr) throws InterruptedException {
        if (null == addr) {
            return this.getAndCreateNameserverChannel();
        }
        ChannelWrapper cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return cw.getChannel();
        }
        return this.createChannel(addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Channel getAndCreateNameserverChannel() throws InterruptedException {
        ChannelWrapper cw;
        String addr = this.namesrvAddrChoosed.get();
        if (addr != null && (cw = this.channelTables.get(addr)) != null && cw.isOK()) {
            return cw.getChannel();
        }
        List<String> addrList = this.namesrvAddrList.get();
        if (this.lockNamesrvChannel.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                ChannelWrapper cw2;
                addr = this.namesrvAddrChoosed.get();
                if (addr != null && (cw2 = this.channelTables.get(addr)) != null && cw2.isOK()) {
                    Channel channel = cw2.getChannel();
                    return channel;
                }
                if (addrList == null || addrList.isEmpty()) return null;
                for (int i = 0; i < addrList.size(); ++i) {
                    int index = this.namesrvIndex.incrementAndGet();
                    index = Math.abs(index);
                    String newAddr = addrList.get(index %= addrList.size());
                    this.namesrvAddrChoosed.set(newAddr);
                    Channel channelNew = this.createChannel(newAddr);
                    if (channelNew == null) continue;
                    Channel channel = channelNew;
                    return channel;
                }
                return null;
            }
            catch (Exception e) {
                log.error((Object)"getAndCreateNameserverChannel: create name server channel exception", (Throwable)e);
                return null;
            }
            finally {
                this.lockNamesrvChannel.unlock();
            }
        } else {
            log.warn((Object)"getAndCreateNameserverChannel: try to lock name server, but timeout, {3000}ms");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Channel createChannel(String addr) throws InterruptedException {
        cw = this.channelTables.get(addr);
        if (cw != null && cw.isOK()) {
            return ChannelWrapper.access$400(cw);
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                createNewConnection = false;
                cw = this.channelTables.get(addr);
                if (cw != null) {
                    if (cw.isOK()) {
                        var4_6 = ChannelWrapper.access$400(cw);
                        return var4_6;
                    }
                    if (!cw.getChannelFuture().isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(addr);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) ** GOTO lbl34
                channelFuture = this.bootstrap.connect(RemotingHelper.string2SocketAddress(addr));
                NettyRemotingClient.log.info((Object)("createChannel: begin to connect remote host[{" + addr + "}] asynchronously"));
                cw = new ChannelWrapper(channelFuture);
                this.channelTables.put(addr, cw);
            }
            catch (Exception e) {
                NettyRemotingClient.log.error((Object)"createChannel: create channel exception", (Throwable)e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            NettyRemotingClient.log.warn((Object)"createChannel: try to lock channel table, but timeout, {3000}ms");
        }
lbl34:
        // 4 sources

        if (cw != null) {
            channelFuture = cw.getChannelFuture();
            if (channelFuture.awaitUninterruptibly(this.nettyClientConfig.getConnectTimeoutMillis())) {
                if (cw.isOK()) {
                    NettyRemotingClient.log.info((Object)("createChannel: connect remote host[{" + addr + "}] success, {" + channelFuture.toString() + "}"));
                    return ChannelWrapper.access$400(cw);
                }
                NettyRemotingClient.log.warn((Object)("createChannel: connect remote host[" + addr + "] failed, " + channelFuture.toString()), channelFuture.cause());
            } else {
                NettyRemotingClient.log.warn((Object)("createChannel: connect remote host[{" + addr + "}] timeout {" + this.nettyClientConfig.getConnectTimeoutMillis() + "}ms, {" + channelFuture.toString() + "}"));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(String addr, Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            String addrRemote = null == addr ? RemotingHelper.parseChannelRemoteAddr(channel) : addr;
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = this.channelTables.get(addrRemote);
                        log.info((Object)("closeChannel: begin close the channel[{" + addrRemote + "}] Found: {" + (prevCW != null) + "}"));
                        if (null == prevCW) {
                            log.info((Object)("closeChannel: the channel[{" + addrRemote + "}] has been removed from the channel table before"));
                            removeItemFromTable = false;
                        } else if (prevCW.getChannel() != channel) {
                            log.info((Object)("closeChannel: the channel[{" + addrRemote + "}] has been closed before, and has been created again, nothing to do."));
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info((Object)("closeChannel: the channel[{" + addrRemote + "}] was removed from channel table"));
                        }
                        RemotingUtil.closeChannel(channel);
                        break block13;
                    }
                    catch (Exception e) {
                        log.error((Object)"closeChannel: close the channel exception", (Throwable)e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn((Object)"closeChannel: try to lock channel table, but timeout, {3000}ms");
            }
            catch (InterruptedException e) {
                log.error((Object)"closeChannel exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(Channel channel) {
        block12: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = null;
                        String addrRemote = null;
                        for (String key : this.channelTables.keySet()) {
                            ChannelWrapper prev = this.channelTables.get(key);
                            if (prev.getChannel() == null || prev.getChannel() != channel) continue;
                            prevCW = prev;
                            addrRemote = key;
                            break;
                        }
                        if (null == prevCW) {
                            log.info((Object)("eventCloseChannel: the channel[{" + addrRemote + "}] has been removed from the channel table before"));
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addrRemote);
                            log.info((Object)("closeChannel: the channel[{" + addrRemote + "}] was removed from channel table"));
                            RemotingUtil.closeChannel(channel);
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        log.error((Object)"closeChannel: close the channel exception", (Throwable)e);
                        break block12;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                log.warn((Object)"closeChannel: try to lock channel table, but timeout, {3000}ms");
            }
            catch (InterruptedException e) {
                log.error((Object)"closeChannel exception", (Throwable)e);
            }
        }
    }

    @Override
    public void registerProcessor(int requestCode, NettyRequestProcessor processor, ExecutorService executor) {
        ExecutorService executorThis = executor;
        if (null == executor) {
            executorThis = this.publicExecutor;
        }
        Pair<NettyRequestProcessor, ExecutorService> pair = new Pair<NettyRequestProcessor, ExecutorService>(processor, executorThis);
        this.processorTable.put(requestCode, pair);
    }

    @Override
    public RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                RemotingCommand response = this.invokeSyncImpl(channel, request, timeoutMillis);
                if (this.rpcHook != null) {
                    this.rpcHook.doAfterResponse(request, response);
                }
                return response;
            }
            catch (RemotingSendRequestException e) {
                log.warn((Object)("invokeSync: send request exception, so close the channel[{" + addr + "}]"));
                this.closeChannel(addr, channel);
                throw e;
            }
            catch (RemotingTimeoutException e) {
                log.warn((Object)("invokeSync: wait response timeout exception, the channel[{" + addr + "}]"));
                throw e;
            }
        }
        this.closeChannel(addr, channel);
        throw new RemotingConnectException(addr);
    }

    @Override
    public void invokeAsync(String addr, RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
            }
            catch (RemotingSendRequestException e) {
                log.warn((Object)("invokeAsync: send request exception, so close the channel[{" + addr + "}]"));
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public void invokeOneway(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        Channel channel = this.getAndCreateChannel(addr);
        if (channel != null && channel.isActive()) {
            try {
                if (this.rpcHook != null) {
                    this.rpcHook.doBeforeRequest(addr, request);
                }
                this.invokeOnewayImpl(channel, request, timeoutMillis);
            }
            catch (RemotingSendRequestException e) {
                log.warn((Object)("invokeOneway: send request exception, so close the channel[{" + addr + "}]"));
                this.closeChannel(addr, channel);
                throw e;
            }
        } else {
            this.closeChannel(addr, channel);
            throw new RemotingConnectException(addr);
        }
    }

    @Override
    public ExecutorService getCallbackExecutor() {
        return this.publicExecutor;
    }

    @Override
    public void updateNameServerAddressList(List<String> addrs) {
        List<String> old = this.namesrvAddrList.get();
        boolean update = false;
        if (!addrs.isEmpty()) {
            if (null == old) {
                update = true;
            } else if (addrs.size() != old.size()) {
                update = true;
            } else {
                for (int i = 0; i < addrs.size() && !update; ++i) {
                    if (old.contains(addrs.get(i))) continue;
                    update = true;
                }
            }
            if (update) {
                Collections.shuffle(addrs);
                this.namesrvAddrList.set(addrs);
            }
        }
    }

    @Override
    public ChannelEventListener getChannelEventListener() {
        return this.channelEventListener;
    }

    public List<String> getNamesrvAddrList() {
        return this.namesrvAddrList.get();
    }

    @Override
    public List<String> getNameServerAddressList() {
        return this.namesrvAddrList.get();
    }

    public RPCHook getRpcHook() {
        return this.rpcHook;
    }

    @Override
    public void registerRPCHook(RPCHook rpcHook) {
        this.rpcHook = rpcHook;
    }

    @Override
    public RPCHook getRPCHook() {
        return this.rpcHook;
    }

    class NettyConnetManageHandler
    extends ChannelDuplexHandler {
        NettyConnetManageHandler() {
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? "UNKNOW" : localAddress.toString();
            String remote = remoteAddress == null ? "UNKNOW" : remoteAddress.toString();
            log.info((Object)("NETTY CLIENT PIPELINE: CONNECT  {" + local + "} => {" + remote + "}"));
            super.connect(ctx, remoteAddress, localAddress, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CONNECT, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info((Object)("NETTY CLIENT PIPELINE: DISCONNECT {" + remoteAddress + "}"));
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.info((Object)("NETTY CLIENT PIPELINE: CLOSE {" + remoteAddress + "}"));
            NettyRemotingClient.this.closeChannel(ctx.channel());
            super.close(ctx, promise);
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.CLOSE, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            log.warn((Object)("NETTY CLIENT PIPELINE: exceptionCaught {" + remoteAddress + "}"));
            log.warn((Object)"NETTY CLIENT PIPELINE: exceptionCaught exception.", cause);
            NettyRemotingClient.this.closeChannel(ctx.channel());
            if (NettyRemotingClient.this.channelEventListener != null) {
                NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.EXCEPTION, remoteAddress.toString(), ctx.channel()));
            }
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent evnet;
            if (evt instanceof IdleStateEvent && (evnet = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                log.warn((Object)("NETTY CLIENT PIPELINE: IDLE exception [{" + remoteAddress + "}]"));
                NettyRemotingClient.this.closeChannel(ctx.channel());
                if (NettyRemotingClient.this.channelEventListener != null) {
                    NettyRemotingClient.this.putNettyEvent(new NettyEvent(NettyEventType.IDLE, remoteAddress.toString(), ctx.channel()));
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<RemotingCommand> {
        NettyClientHandler() {
        }

        @Override
        protected void channelRead0(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
            NettyRemotingClient.this.processMessageReceived(ctx, msg);
        }
    }

    class ChannelWrapper {
        private final ChannelFuture channelFuture;

        public ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
        }

        public boolean isOK() {
            return this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
        }

        private Channel getChannel() {
            return this.channelFuture.channel();
        }

        public ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }
    }
}

