/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.BytesException;
import com.alibaba.dts.shade.com.taobao.hsf.com.caucho.hessian.io.HessianInput;
import com.alibaba.dts.shade.com.taobao.hsf.com.caucho.hessian.io.HessianOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.MessageDigest;

public class BytesUtil4Client
implements Constants {
    public static boolean isEmpty(byte[] bytes) {
        if (null == bytes) {
            return true;
        }
        return bytes.length <= 0;
    }

    public static byte[] objectToBytes(Object object) throws BytesException {
        if (null == object) {
            throw new BytesException("object is null");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        HessianOutput hessianOutput = new HessianOutput(byteArrayOutputStream);
        try {
            hessianOutput.writeObject(object);
        }
        catch (Exception e) {
            throw new BytesException("write object error", e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object bytesToObject(byte[] bytes) throws BytesException {
        if (null == bytes) {
            throw new BytesException("bytes is null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        HessianInput hessianInput = new HessianInput(byteArrayInputStream);
        Object object = null;
        try {
            object = hessianInput.readObject();
        }
        catch (Exception e) {
            throw new BytesException("read object error", e);
        }
        return object;
    }

    public static String md5(byte[] bytes) throws BytesException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new BytesException("message digest error", e);
        }
        messageDigest.update(bytes);
        byte[] resultBytes = messageDigest.digest();
        return BytesUtil4Client.bytesToHex(resultBytes);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] resultCharArray = new char[32];
        int index = 0;
        for (int i = 0; i < 16; ++i) {
            resultCharArray[index++] = hexDigits[bytes[i] >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[bytes[i] & 0xF];
        }
        return new String(resultCharArray);
    }
}

