/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobStatusEnum;
import com.alibaba.dts.common.domain.store.JobTypeEnum;
import com.alibaba.dts.common.domain.store.assemble.AssembledMonitor;
import com.alibaba.dts.common.domain.store.assemble.WarningNotifier;
import com.alibaba.dts.common.util.CommonUtil;
import com.alibaba.dts.common.util.CronExpression;
import com.alibaba.dts.common.util.StringUtil;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckUtil {
    private static final Log logger = LogFactory.getLog(CheckUtil.class);

    public static Result<Boolean> checkJob(Job job) {
        Result<Boolean> checkResult = new Result<Boolean>(false);
        if (CommonUtil.isApiJob(job.getType())) {
            checkResult.setResultCode(ResultCode.SUCCESS);
            checkResult.setData(true);
            return checkResult;
        }
        if (!CronExpression.isValidExpression(StringUtil.trim(job.getCronExpression()))) {
            checkResult.setResultCode(ResultCode.CRON_EXPRESSION_ERROR);
            return checkResult;
        }
        try {
            CronExpression expression = new CronExpression(job.getCronExpression());
            Date nextFireTime = expression.getNextValidTimeAfter(new Date());
            if (null == nextFireTime) {
                checkResult.setResultCode(ResultCode.CRON_EXPRESSION_OBSOLETE);
                return checkResult;
            }
        }
        catch (Throwable e) {
            logger.error((Object)("[CheckUtil]: getNextValidTimeAfter error, job:" + job), e);
            checkResult.setResultCode(ResultCode.FAILURE);
            return checkResult;
        }
        checkResult.setResultCode(ResultCode.SUCCESS);
        checkResult.setData(true);
        return checkResult;
    }

    public static boolean jobTypeIsDefine(int jobtype) {
        Boolean result = false;
        for (JobTypeEnum typeItem : JobTypeEnum.values()) {
            if (typeItem.getType() != jobtype) continue;
            return true;
        }
        return result;
    }

    public static boolean jobStatusIsDefine(int jobstatus) {
        Boolean result = false;
        for (JobStatusEnum typeItem : JobStatusEnum.values()) {
            if (typeItem.getStatus() != jobstatus) continue;
            return true;
        }
        return result;
    }

    public static Result<Boolean> checkUserConfigJob(Job job) {
        Result<Boolean> result = new Result<Boolean>(false);
        if (StringUtil.isBlank(job.getCronExpression())) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u65f6\u95f4\u8868\u8fbe\u5f0f\u4e3a\u7a7a!");
            return result;
        }
        if (StringUtil.isBlank(job.getJobProcessor())) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u5904\u7406\u5668\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a!");
            return result;
        }
        if (!CheckUtil.jobTypeIsDefine(job.getType())) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("Job \u7c7b\u578b\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4!");
            return result;
        }
        if (!CheckUtil.jobStatusIsDefine(job.getStatus())) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("Job \u72b6\u6001\u8bbe\u7f6e\u8d85\u51fa\u8303\u56f4!");
            return result;
        }
        if (!CronExpression.isValidExpression(StringUtil.trim(job.getCronExpression()))) {
            result.setResultCode(ResultCode.CRON_EXPRESSION_ERROR);
            return result;
        }
        result.setResultCode(ResultCode.SUCCESS);
        result.setData(true);
        return result;
    }

    public static Result<Boolean> checkUserConfigMonitor(AssembledMonitor assembledMonitor) {
        Result<Boolean> result = new Result<Boolean>(false);
        if (assembledMonitor.getJobId() == 0L) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("Job ID\u9700\u8981\u8bbe\u7f6e!");
            return result;
        }
        if (assembledMonitor.getErrorRate() >= 1.0) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u9519\u8bef\u7387\u4e0d\u80fd\u8fbe\u5230\u6216\u8d85\u8fc7100%!");
            return result;
        }
        if (assembledMonitor.getTimeoutLimit() <= 0L) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u8d85\u65f6\u65f6\u95f4\u4e0d\u80fd\u8bbe\u7f6e\u4e3a0\u6216\u8005\u5c0f\u4e8e0!");
            return result;
        }
        if (assembledMonitor.getNotifiers().size() == 0) {
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u544a\u8b66\u901a\u77e5\u4eba\u4e0d\u8981\u4e3a\u7a7a!");
            return result;
        }
        for (WarningNotifier warningNotifier : assembledMonitor.getNotifiers()) {
            Pattern phonePattern;
            Matcher matcher;
            String mobileId = warningNotifier.getMobileId();
            if (!StringUtil.isNotBlank(mobileId) || (matcher = (phonePattern = Pattern.compile("^1\\d{10}$")).matcher(mobileId)).find()) continue;
            result.setResultCode(ResultCode.USER_PARAMETER_ERROR);
            result.getResultCode().setInformation("\u62a5\u8b66\u624b\u673a\u53f7\u7801\u8bbe\u7f6e\u6709\u8bef!" + mobileId);
            return result;
        }
        result.setData(true);
        result.setResultCode(ResultCode.SUCCESS);
        return null;
    }
}

