/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.shade.io.netty.channel.Channel;
import com.alibaba.dts.shade.io.netty.channel.ChannelFuture;
import com.alibaba.dts.shade.io.netty.channel.ChannelFutureListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemotingUtil
implements Constants {
    private static final Log log = LogFactory.getLog(RemotingUtil.class);
    public static final String OS_NAME = System.getProperty("os.name");
    private static boolean isLinuxPlatform = false;
    private static boolean isWindowsPlatform = false;

    public static boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static boolean isWindowsPlatform() {
        return isWindowsPlatform;
    }

    public static Selector openSelector() throws IOException {
        Selector result;
        block7: {
            result = null;
            if (RemotingUtil.isLinuxPlatform()) {
                try {
                    Class<?> providerClazz = Class.forName("sun.nio.ch.EPollSelectorProvider");
                    if (providerClazz == null) break block7;
                    try {
                        SelectorProvider selectorProvider;
                        Method method = providerClazz.getMethod("provider", new Class[0]);
                        if (method != null && (selectorProvider = (SelectorProvider)method.invoke(null, new Object[0])) != null) {
                            result = selectorProvider.openSelector();
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            result = Selector.open();
        }
        return result;
    }

    public static String getLocalAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                while (en.hasMoreElements()) {
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address instanceof Inet6Address) {
                        ipv6Result.add(RemotingUtil.normalizeHostAddress(address));
                        continue;
                    }
                    ipv4Result.add(RemotingUtil.normalizeHostAddress(address));
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (ip.startsWith("127.0") || ip.startsWith("192.168") || !ip.startsWith("10.")) continue;
                    log.warn((Object)("[RemotingUtil]: ipv4Result ip:" + ip + ", ipv4Result:" + ipv4Result));
                    return ip;
                }
                log.warn((Object)("[RemotingUtil]: ipv4Result last ip, ipv4Result:" + ipv4Result));
                return (String)ipv4Result.get(0);
            }
            if (!ipv6Result.isEmpty()) {
                return (String)ipv6Result.get(0);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            return RemotingUtil.normalizeHostAddress(localHost);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        String[] s = addr.split(":");
        InetSocketAddress isa = new InetSocketAddress(s[0], (int)Integer.valueOf(s[1]));
        return isa;
    }

    public static String socketAddress2String(SocketAddress addr) {
        StringBuilder sb = new StringBuilder();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)addr;
        sb.append(inetSocketAddress.getAddress().getHostAddress());
        sb.append(":");
        sb.append(inetSocketAddress.getPort());
        return sb.toString();
    }

    public static SocketChannel connect(SocketAddress remote) {
        return RemotingUtil.connect(remote, 5000);
    }

    public static SocketChannel connect(SocketAddress remote, int timeoutMillis) {
        SocketChannel sc = null;
        try {
            sc = SocketChannel.open();
            sc.configureBlocking(true);
            sc.socket().setSoLinger(false, -1);
            sc.socket().setTcpNoDelay(true);
            sc.socket().setReceiveBufferSize(65536);
            sc.socket().setSendBufferSize(65536);
            sc.socket().connect(remote, timeoutMillis);
            sc.configureBlocking(false);
            return sc;
        }
        catch (Exception e) {
            if (sc != null) {
                try {
                    sc.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    public static String parseIpFromAddress(String address) {
        return address.split(":")[0];
    }

    public static void closeChannel(Channel channel) {
        final String addrRemote = RemotingHelper.parseChannelRemoteAddr(channel);
        channel.close().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                log.info((Object)("closeChannel: close the connection to remote address[{" + addrRemote + "}] result: {" + future.isSuccess() + "}"));
            }
        });
    }

    public static String getLocalHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable e) {
            throw new RuntimeException("[RemotingUtil]:getLocalHostname error", e);
        }
    }

    static {
        if (OS_NAME != null && OS_NAME.toLowerCase().indexOf("linux") >= 0) {
            isLinuxPlatform = true;
        }
        if (OS_NAME != null && OS_NAME.toLowerCase().indexOf("windows") >= 0) {
            isWindowsPlatform = true;
        }
    }
}

