/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.alibaba.common.logging.spi.jdk14;

import com.alibaba.dts.shade.com.alibaba.common.logging.Logger;
import com.alibaba.dts.shade.com.alibaba.common.logging.MappedDiagnosticContext;
import com.alibaba.dts.shade.com.alibaba.common.logging.NestedDiagnosticContext;
import com.alibaba.dts.shade.com.alibaba.common.logging.spi.LoggerUtil;
import com.alibaba.dts.shade.com.alibaba.common.logging.spi.NoopDiagnosticContext;
import java.util.ResourceBundle;
import java.util.logging.Level;

public final class JDK14Logger
implements Logger {
    private static final Level LEVEL_TRACE = Level.FINEST;
    private static final Level LEVEL_DEBUG = Level.FINE;
    private static final Level LEVEL_INFO = Level.INFO;
    private static final Level LEVEL_WARN = Level.WARNING;
    private static final Level LEVEL_ERROR = Level.SEVERE;
    private static final Level LEVEL_FATAL = Level.SEVERE;
    private static final String FQCN = Logger.class.getPackage().getName() + ".";
    private java.util.logging.Logger logger;
    private ResourceBundle bundle;

    public JDK14Logger(String name) {
        this.logger = java.util.logging.Logger.getLogger(name);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(LEVEL_TRACE);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(LEVEL_DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(LEVEL_INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(LEVEL_WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(LEVEL_ERROR);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(LEVEL_FATAL);
    }

    public void trace(Object message) {
        this.log(LEVEL_TRACE, message, null);
    }

    public void trace(Object message, Throwable cause) {
        this.log(LEVEL_TRACE, message, cause);
    }

    public void trace(Object key, Object[] params) {
        this.l7dlog(LEVEL_TRACE, key, params, null);
    }

    public void trace(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_TRACE, key, params, cause);
    }

    public void debug(Object message) {
        this.log(LEVEL_DEBUG, message, null);
    }

    public void debug(Object message, Throwable cause) {
        this.log(LEVEL_DEBUG, message, cause);
    }

    public void debug(Object key, Object[] params) {
        this.l7dlog(LEVEL_DEBUG, key, params, null);
    }

    public void debug(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_DEBUG, key, params, cause);
    }

    public void info(Object message) {
        this.log(LEVEL_INFO, message, null);
    }

    public void info(Object message, Throwable cause) {
        this.log(LEVEL_INFO, message, cause);
    }

    public void info(Object key, Object[] params) {
        this.l7dlog(LEVEL_INFO, key, params, null);
    }

    public void info(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_INFO, key, params, cause);
    }

    public void warn(Object message) {
        this.log(LEVEL_WARN, message, null);
    }

    public void warn(Object message, Throwable cause) {
        this.log(LEVEL_WARN, message, cause);
    }

    public void warn(Object key, Object[] params) {
        this.l7dlog(LEVEL_WARN, key, params, null);
    }

    public void warn(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_WARN, key, params, cause);
    }

    public void error(Object message) {
        this.log(LEVEL_ERROR, message, null);
    }

    public void error(Object message, Throwable cause) {
        this.log(LEVEL_ERROR, message, cause);
    }

    public void error(Object key, Object[] params) {
        this.l7dlog(LEVEL_ERROR, key, params, null);
    }

    public void error(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_ERROR, key, params, cause);
    }

    public void fatal(Object message) {
        this.log(LEVEL_FATAL, message, null);
    }

    public void fatal(Object message, Throwable cause) {
        this.log(LEVEL_FATAL, message, cause);
    }

    public void fatal(Object key, Object[] params) {
        this.l7dlog(LEVEL_FATAL, key, params, null);
    }

    public void fatal(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_FATAL, key, params, cause);
    }

    private void log(Level level, Object message, Throwable cause) {
        if (this.logger.isLoggable(level)) {
            this.forcedLog(level, message, cause);
        }
    }

    private void l7dlog(Level level, Object key, Object[] params, Throwable cause) {
        if (this.logger.isLoggable(level)) {
            this.forcedLog(level, LoggerUtil.getMessage(this, key, params), cause);
        }
    }

    private void forcedLog(Level level, Object message, Throwable cause) {
        StackTraceElement[] locations = new Throwable().getStackTrace();
        String callerClass = "UnknownClass";
        String callerMethod = "unknownMethod";
        if (locations != null) {
            for (int i = 2; i < locations.length; ++i) {
                StackTraceElement element = locations[i];
                String className = element.getClassName();
                if (className == null || className.startsWith(FQCN)) continue;
                callerClass = className;
                callerMethod = element.getMethodName();
                break;
            }
        }
        if (cause == null) {
            this.logger.logp(level, callerClass, callerMethod, String.valueOf(message));
        } else {
            this.logger.logp(level, callerClass, callerMethod, String.valueOf(message), cause);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String toString() {
        return this.logger.getName();
    }

    public NestedDiagnosticContext getNestedDiagnosticContext() {
        return NoopDiagnosticContext.getInstance();
    }

    public MappedDiagnosticContext getMappedDiagnosticContext() {
        return NoopDiagnosticContext.getInstance();
    }
}

