/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.alibaba.common.logging.spi.log4j;

import com.alibaba.dts.shade.com.alibaba.common.logging.Logger;
import com.alibaba.dts.shade.com.alibaba.common.logging.MappedDiagnosticContext;
import com.alibaba.dts.shade.com.alibaba.common.logging.NestedDiagnosticContext;
import com.alibaba.dts.shade.com.alibaba.common.logging.spi.LoggerUtil;
import com.alibaba.dts.shade.com.alibaba.common.logging.spi.log4j.Level;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import org.apache.log4j.MDC;
import org.apache.log4j.NDC;
import org.apache.log4j.Priority;

public final class Log4jLogger
implements Logger,
NestedDiagnosticContext,
MappedDiagnosticContext {
    private static final org.apache.log4j.Level LEVEL_TRACE;
    private static final org.apache.log4j.Level LEVEL_DEBUG;
    private static final org.apache.log4j.Level LEVEL_INFO;
    private static final org.apache.log4j.Level LEVEL_WARN;
    private static final org.apache.log4j.Level LEVEL_ERROR;
    private static final org.apache.log4j.Level LEVEL_FATAL;
    private static final String FQCN;
    private org.apache.log4j.Logger logger;

    public Log4jLogger(String name) {
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public org.apache.log4j.Logger getLog4jLogger() {
        return this.logger;
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabledFor((Priority)LEVEL_TRACE);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabledFor((Priority)LEVEL_DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabledFor((Priority)LEVEL_INFO);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)LEVEL_WARN);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)LEVEL_ERROR);
    }

    public boolean isFatalEnabled() {
        return this.logger.isEnabledFor((Priority)LEVEL_FATAL);
    }

    public void trace(Object message) {
        this.logger.log(FQCN, (Priority)LEVEL_TRACE, message, null);
    }

    public void trace(Object message, Throwable cause) {
        this.logger.log(FQCN, (Priority)LEVEL_TRACE, message, cause);
    }

    public void trace(Object key, Object[] params) {
        this.l7dlog(LEVEL_TRACE, key, params, null);
    }

    public void trace(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_TRACE, key, params, cause);
    }

    public void debug(Object message) {
        this.logger.log(FQCN, (Priority)LEVEL_DEBUG, message, null);
    }

    public void debug(Object message, Throwable cause) {
        this.logger.log(FQCN, (Priority)LEVEL_DEBUG, message, cause);
    }

    public void debug(Object key, Object[] params) {
        this.l7dlog(LEVEL_DEBUG, key, params, null);
    }

    public void debug(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_DEBUG, key, params, cause);
    }

    public void info(Object message) {
        this.logger.log(FQCN, (Priority)LEVEL_INFO, message, null);
    }

    public void info(Object message, Throwable cause) {
        this.logger.log(FQCN, (Priority)LEVEL_INFO, message, cause);
    }

    public void info(Object key, Object[] params) {
        this.l7dlog(LEVEL_INFO, key, params, null);
    }

    public void info(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_INFO, key, params, cause);
    }

    public void warn(Object message) {
        this.logger.log(FQCN, (Priority)LEVEL_WARN, message, null);
    }

    public void warn(Object message, Throwable cause) {
        this.logger.log(FQCN, (Priority)LEVEL_WARN, message, cause);
    }

    public void warn(Object key, Object[] params) {
        this.l7dlog(LEVEL_WARN, key, params, null);
    }

    public void warn(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_WARN, key, params, cause);
    }

    public void error(Object message) {
        this.logger.log(FQCN, (Priority)LEVEL_ERROR, message, null);
    }

    public void error(Object message, Throwable cause) {
        this.logger.log(FQCN, (Priority)LEVEL_ERROR, message, cause);
    }

    public void error(Object key, Object[] params) {
        this.l7dlog(LEVEL_ERROR, key, params, null);
    }

    public void error(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_ERROR, key, params, cause);
    }

    public void fatal(Object message) {
        this.logger.log(FQCN, (Priority)LEVEL_FATAL, message, null);
    }

    public void fatal(Object message, Throwable cause) {
        this.logger.log(FQCN, (Priority)LEVEL_FATAL, message, null);
    }

    public void fatal(Object key, Object[] params) {
        this.l7dlog(LEVEL_FATAL, key, params, null);
    }

    public void fatal(Object key, Object[] params, Throwable cause) {
        this.l7dlog(LEVEL_FATAL, key, params, cause);
    }

    private void l7dlog(org.apache.log4j.Level level, Object key, Object[] params, Throwable cause) {
        if (this.logger.isEnabledFor((Priority)level)) {
            this.logger.log(FQCN, (Priority)level, (Object)LoggerUtil.getMessage(this, key, params), cause);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.logger.setResourceBundle(bundle);
    }

    public String toString() {
        return this.logger.getName();
    }

    public NestedDiagnosticContext getNestedDiagnosticContext() {
        return this;
    }

    public MappedDiagnosticContext getMappedDiagnosticContext() {
        return this;
    }

    public void clearNDC() {
        NDC.clear();
    }

    public Stack cloneNDCStack() {
        return NDC.cloneStack();
    }

    public String getNDC() {
        return NDC.get();
    }

    public int getNDCDepth() {
        return NDC.getDepth();
    }

    public void inheritNDC(Stack stack) {
        NDC.inherit((Stack)stack);
    }

    public void popNDC() {
        NDC.pop();
    }

    public void pushNDC(String s) {
        NDC.push((String)s);
    }

    public void removeNDC() {
        NDC.remove();
    }

    public void setNDCMaxDepth(int i) {
        NDC.setMaxDepth((int)i);
    }

    public void putMDC(String key, Object obj) {
        if (obj == null) {
            MDC.remove((String)key);
        } else {
            MDC.put((String)key, (Object)obj);
        }
    }

    public Object getMDC(String key) {
        return MDC.get((String)key);
    }

    public void removeMDC(String key) {
        MDC.remove((String)key);
    }

    public Map getMDCContext() {
        return MDC.getContext();
    }

    static {
        Level traceLevel;
        LEVEL_DEBUG = org.apache.log4j.Level.DEBUG;
        LEVEL_INFO = org.apache.log4j.Level.INFO;
        LEVEL_WARN = org.apache.log4j.Level.WARN;
        LEVEL_ERROR = org.apache.log4j.Level.ERROR;
        LEVEL_FATAL = org.apache.log4j.Level.FATAL;
        FQCN = Logger.class.getPackage().getName() + ".";
        try {
            Field traceField = org.apache.log4j.Level.class.getField("TRACE");
            traceLevel = traceField != null ? (org.apache.log4j.Level)traceField.get(null) : Level.TRACE;
        }
        catch (Exception e) {
            traceLevel = Level.TRACE;
        }
        LEVEL_TRACE = traceLevel;
    }
}

