/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.diamond.client.impl;

import com.alibaba.dts.shade.com.taobao.diamond.client.impl.CacheData;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.DiamondEnv;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.HttpSimpleClient;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.SpasAdapter;
import com.alibaba.dts.shade.com.taobao.diamond.common.Constants;
import com.alibaba.dts.shade.com.taobao.diamond.common.GroupKey;
import com.alibaba.dts.shade.com.taobao.diamond.md5.MD5;
import com.alibaba.dts.shade.com.taobao.diamond.mockserver.MockServer;
import com.alibaba.dts.shade.com.taobao.diamond.utils.ContentUtils;
import com.alibaba.dts.shade.com.taobao.diamond.utils.StringUtils;
import com.taobao.middleware.logger.support.LoggerHelper;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ClientWorker {
    final ScheduledExecutorService executor;
    final DiamondEnv env;

    static String getServerConfig(DiamondEnv env, String dataId, String group, long readTimeout) throws IOException {
        if (StringUtils.isBlank(group)) {
            group = "DEFAULT_GROUP";
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, env);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            List<String> params = Arrays.asList("dataId", dataId, "group", group);
            result = env.agent.httpGet("/config.co", SpasAdapter.getSignHeaders(group), params, "GBK", readTimeout);
        }
        catch (IOException e) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server] get server config exception, dataId={}, group={}, msg={}", new Object[]{dataId, group, e.toString()});
            throw e;
        }
        switch (result.code) {
            case 200: {
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, result.content);
                return result.content;
            }
            case 404: {
                LocalConfigInfoProcessor.saveSnapshot(env, dataId, group, null);
                return null;
            }
            case 409: {
                DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error] get server config being modified concurrently, dataId={}, group={}", new Object[]{dataId, group});
                throw new IOException("data being modified, dataId=" + dataId + ",group=" + group);
            }
            case 403: {
                DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error] no right, dataId={}, group={}", new Object[]{dataId, group});
                throw new IOException("No right");
            }
        }
        DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-server-error]  dataId={}, group={}, code={}", new Object[]{dataId, group, result.code});
        throw new IOException("http error, code=" + result.code + ",dataId=" + dataId + ",group=" + group);
    }

    private void checkLocalConfigInfo() {
        for (CacheData cacheData : this.env.getAllCacheDataSnapshot()) {
            try {
                ClientWorker.checkLocalConfig(this.env, cacheData);
            }
            catch (Exception e) {
                DiamondEnv.log.error("DIAMOND-CLIENT", "get local config info error", (Throwable)e);
            }
        }
        ClientWorker.checkListenerMd5(this.env);
    }

    static void checkLocalConfig(DiamondEnv env, CacheData cacheData) {
        String dataId = cacheData.dataId;
        String group = cacheData.group;
        File path = LocalConfigInfoProcessor.getFailoverFile(env, dataId, group);
        if (!cacheData.isUseLocalConfigInfo() && path.exists()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file created. dataId={}, group={}, md5={}, content={}", new Object[]{dataId, group, md5, ContentUtils.truncateContent(content)});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && !path.exists()) {
            cacheData.setUseLocalConfigInfo(false);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file deleted. dataId={}, group={}", new Object[]{dataId, group});
            return;
        }
        if (cacheData.isUseLocalConfigInfo() && path.exists() && cacheData.getLocalConfigInfoVersion() != path.lastModified()) {
            String content = LocalConfigInfoProcessor.getFailover(env, dataId, group);
            String md5 = MD5.getInstance().getMD5String(content);
            cacheData.setUseLocalConfigInfo(true);
            cacheData.setLocalConfigInfoVersion(path.lastModified());
            cacheData.setContent(content);
            DiamondEnv.log.warn(env.getName(), "[failover-change] failover file changed. dataId={}, group={}, md5={}, content={}", new Object[]{dataId, group, md5, ContentUtils.truncateContent(content)});
            return;
        }
    }

    public void checkServerConfigInfo() {
        ClientWorker.checkServerConfigInfo(this.env);
    }

    public static void checkServerConfigInfo(DiamondEnv env) {
        List<String> changedGroupKeys = ClientWorker.checkUpdateDataIds(env);
        for (String groupKey : changedGroupKeys) {
            String dataId = GroupKey.parseKey(groupKey)[0];
            String group = GroupKey.parseKey(groupKey)[1];
            try {
                String content = ClientWorker.getServerConfig(env, dataId, group, 3000L);
                CacheData cache = env.getCache(dataId, group);
                cache.setContent(content);
                DiamondEnv.log.info(env.getName(), "[data-received] dataId={}, group={}, md5={}, content={}", new Object[]{dataId, group, cache.getMd5(), ContentUtils.truncateContent(content)});
            }
            catch (IOException ioe) {
                DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[get-update] get changed config exception. dataId={}, group={}, msg={}", new Object[]{dataId, group, ioe.toString()});
            }
        }
        ClientWorker.checkListenerMd5(env);
    }

    static List<String> checkUpdateDataIds(DiamondEnv env) {
        if (MockServer.isTestMode()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ArrayList<String> updateList = new ArrayList<String>();
            for (CacheData cacheData : env.getAllCacheDataSnapshot()) {
                if (CacheData.getMd5String(MockServer.getConfigInfo(cacheData.dataId, cacheData.group, env)).equals(cacheData.getMd5())) continue;
                updateList.add(GroupKey.getKey(cacheData.dataId, cacheData.group));
            }
            return updateList;
        }
        String probeUpdateString = ClientWorker.getProbeUpdateString(env);
        List<String> params = Arrays.asList("Probe-Modify-Request", probeUpdateString);
        long timeout = TimeUnit.SECONDS.toMillis(30L);
        List<String> headers = Arrays.asList("longPullingTimeout", "" + timeout);
        if (StringUtils.isBlank(probeUpdateString)) {
            return Collections.emptyList();
        }
        try {
            HttpSimpleClient.HttpResult result = env.agent.httpPost("/config.co", headers, params, "GBK", timeout);
            if (200 == result.code) {
                return ClientWorker.parseUpdateDataIdResponse(env, result.content);
            }
            if (result.code == 500) {
                DiamondEnv.log.error("Diamond-0007", LoggerHelper.getErrorCodeStr((String)"Diamond", (String)"Diamond-0007", (String)"\u73af\u5883\u95ee\u9898", (String)"[check-update] get changed dataId error"));
            }
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[check-update] get changed dataId error, code={}", new Object[]{result.code});
        }
        catch (IOException e) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[check-update] get changed dataId exception, msg={}", new Object[]{e.toString()});
        }
        return Collections.emptyList();
    }

    private static String getProbeUpdateString(DiamondEnv env) {
        StringBuilder sb = new StringBuilder();
        for (CacheData cacheData : env.getAllCacheDataSnapshot()) {
            if (cacheData.isUseLocalConfigInfo()) continue;
            if (cacheData.isInitializing()) {
                cacheData.setContent(LocalConfigInfoProcessor.getSnapshot(env, cacheData.dataId, cacheData.group));
                cacheData.setInitializing(false);
            }
            sb.append(cacheData.dataId).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.group).append(Constants.WORD_SEPARATOR);
            sb.append(cacheData.getMd5()).append(Constants.LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private static List<String> parseUpdateDataIdResponse(DiamondEnv env, String response) {
        if (StringUtils.isBlank(response)) {
            return Collections.emptyList();
        }
        try {
            response = URLDecoder.decode(response, "UTF-8");
        }
        catch (Exception e) {
            DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[polling-resp] decode modifiedDataIdsString error", (Throwable)e);
        }
        LinkedList<String> updateList = new LinkedList<String>();
        for (String dataIdAndGroup : response.split(Constants.LINE_SEPARATOR)) {
            int idx;
            if (StringUtils.isBlank(dataIdAndGroup) || (idx = dataIdAndGroup.indexOf(Constants.WORD_SEPARATOR)) <= 0) continue;
            String dataId = dataIdAndGroup.substring(0, idx);
            String group = dataIdAndGroup.substring(idx + 1);
            updateList.add(GroupKey.getKey(dataId, group));
            DiamondEnv.log.info(env.getName(), "[polling-resp] config changed. dataId={}, group={}", new Object[]{dataId, group});
        }
        return updateList;
    }

    static void checkListenerMd5(DiamondEnv env) {
        for (CacheData cacheData : env.getAllCacheDataSnapshot()) {
            cacheData.checkListenerMd5();
        }
    }

    ClientWorker(final DiamondEnv env) {
        this.env = env;
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("com.alibaba.dts.shade.com.taobao.diamond.client.Worker." + env.serverMgr.name);
                t.setDaemon(true);
                return t;
            }
        });
        this.executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ClientWorker.this.checkLocalConfigInfo();
                    ClientWorker.this.checkServerConfigInfo();
                }
                catch (Throwable e) {
                    DiamondEnv.log.error(env.getName(), "DIAMOND-XXXX", "[sub-check] rotate check error", e);
                }
            }
        }, 1L, 1L, TimeUnit.MILLISECONDS);
    }
}

