/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.diamond.client.impl;

import com.alibaba.dts.shade.com.taobao.diamond.client.impl.DiamondEnv;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.IOUtils;
import com.alibaba.dts.shade.com.taobao.diamond.client.impl.ServerHttpAgent;
import com.alibaba.dts.shade.com.taobao.diamond.md5.MD5;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class HttpSimpleClient {
    static String DIAMOND_CLIENT_VERSION = "unknown";
    static final int DIAMOND_CONNECT_TIMEOUT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpGet(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        url = url + (null == encodedContent ? "" : "?" + encodedContent);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 100 ? DIAMOND_CONNECT_TIMEOUT : 100);
            conn.setReadTimeout((int)readTimeoutMs);
            HttpSimpleClient.setHeaders(conn, headers, encoding);
            conn.connect();
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpPost(String url, List<String> headers, List<String> paramValues, String encoding, long readTimeoutMs) throws IOException {
        String encodedContent = HttpSimpleClient.encodingParams(paramValues, encoding);
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(DIAMOND_CONNECT_TIMEOUT > 3000 ? DIAMOND_CONNECT_TIMEOUT : 3000);
            conn.setReadTimeout((int)readTimeoutMs);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            HttpSimpleClient.setHeaders(conn, headers, encoding);
            conn.getOutputStream().write(encodedContent.getBytes());
            int respCode = conn.getResponseCode();
            String resp = null;
            resp = 200 == respCode ? IOUtils.toString(conn.getInputStream(), encoding) : IOUtils.toString(conn.getErrorStream(), encoding);
            HttpResult httpResult = new HttpResult(respCode, resp);
            return httpResult;
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    private static void setHeaders(HttpURLConnection conn, List<String> headers, String encoding) {
        if (null != headers) {
            Iterator<String> iter = headers.iterator();
            while (iter.hasNext()) {
                conn.addRequestProperty(iter.next(), iter.next());
            }
        }
        conn.addRequestProperty("Client-Version", DIAMOND_CLIENT_VERSION);
        conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=" + encoding);
        String ts = String.valueOf(System.currentTimeMillis());
        String token = MD5.getInstance().getMD5String(ts + ServerHttpAgent.appKey);
        conn.addRequestProperty("Diamond-Client-AppName", ServerHttpAgent.appName);
        conn.addRequestProperty("Diamond-Client-RequestTS", ts);
        conn.addRequestProperty("Diamond-Client-RequestToken", token);
    }

    private static String encodingParams(List<String> paramValues, String encoding) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        if (null == paramValues) {
            return null;
        }
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append("=");
            sb.append(URLEncoder.encode(iter.next(), encoding));
            if (!iter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    static {
        String tmp = "1000";
        try {
            tmp = System.getProperty("DIAMOND.CONNECT.TIMEOUT", "1000");
            DIAMOND_CONNECT_TIMEOUT = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            String msg = "[http-client] invalid connect timeout:" + tmp;
            DiamondEnv.log.error("settings", "DIAMOND-XXXX", msg, (Throwable)e);
            throw new IllegalArgumentException(msg, e);
        }
        DiamondEnv.log.info("settings", "[http-client] connect timeout:{}", new Object[]{DIAMOND_CONNECT_TIMEOUT});
        try {
            URL configURL = HttpSimpleClient.class.getResource("/application.properties");
            if (configURL != null) {
                URI configURI = configURL.toURI();
                File file = new File(configURI);
                Properties props = new Properties();
                props.load(new FileInputStream(file));
                String val = null;
                val = props.getProperty("version");
                if (val != null) {
                    DIAMOND_CLIENT_VERSION = val;
                }
                DiamondEnv.log.info("DIAMOND_CLIENT_VERSION:{}", DIAMOND_CLIENT_VERSION);
            } else {
                DiamondEnv.log.error("500", "configURL is null");
            }
        }
        catch (Exception e) {
            DiamondEnv.log.error("500", "read config.properties wrong", (Throwable)e);
        }
    }

    public static class HttpResult {
        public final int code;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }
    }
}

