/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.FastDateFormat;
import com.alibaba.dts.shade.com.taobao.eagleeye.RpcContext_inner;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.CRC32;

final class EagleEyeCoreUtils {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\r\n";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String LOCAL_IP_ADDRESS = EagleEyeCoreUtils.getLocalInetAddress();
    private static final ThreadLocal<FastDateFormat> dateFmt = new ThreadLocal<FastDateFormat>(){

        @Override
        protected FastDateFormat initialValue() {
            return new FastDateFormat();
        }
    };

    EagleEyeCoreUtils() {
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String checkNotNullEmpty(String value, String name) throws IllegalArgumentException {
        if (EagleEyeCoreUtils.isBlank(value)) {
            throw new IllegalArgumentException(name + " is null or empty");
        }
        return value;
    }

    public static <T> T checkNotNull(T value, String name) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(name + " is null");
        }
        return value;
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static boolean isNotBlank(String str) {
        return !EagleEyeCoreUtils.isBlank(str);
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String[] split(String str, char separatorChar) {
        return EagleEyeCoreUtils.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static StringBuilder appendWithBlankCheck(String str, String defaultValue, StringBuilder appender) {
        if (EagleEyeCoreUtils.isNotBlank(str)) {
            appender.append(str);
        } else {
            appender.append(defaultValue);
        }
        return appender;
    }

    public static StringBuilder appendWithNullCheck(Object obj, String defaultValue, StringBuilder appender) {
        if (obj != null) {
            appender.append(obj.toString());
        } else {
            appender.append(defaultValue);
        }
        return appender;
    }

    public static StringBuilder appendLog(String str, StringBuilder appender, char delimiter) {
        if (str != null) {
            int len = str.length();
            appender.ensureCapacity(appender.length() + len);
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c == '\n' || c == '\r' || c == delimiter) {
                    c = ' ';
                }
                appender.append(c);
            }
        }
        return appender;
    }

    public static String filterInvalidCharacters(String str) {
        StringBuilder appender = new StringBuilder(str.length());
        return EagleEyeCoreUtils.appendLog(str, appender, '|').toString();
    }

    public static String digest(String str) {
        CRC32 crc = new CRC32();
        crc.update(str.getBytes());
        return Long.toHexString(crc.getValue());
    }

    public static String formatTime(long timestamp) {
        return dateFmt.get().format(timestamp);
    }

    private static String getLocalInetAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    public static String getLocalAddress() {
        return LOCAL_IP_ADDRESS;
    }

    public static boolean isClusterTestEnabled(RpcContext_inner ctx) {
        return ctx != null && "1".equals(ctx.getUserData("t"));
    }
}

