/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeRequestTracer;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EagleEyeFilter
implements Filter {
    private static final String USE_LOCAL_IP = "useLocalIp";
    private boolean useLocalIp = false;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            String ip = null;
            if (!this.useLocalIp) {
                ip = EagleEyeRequestTracer.getRemoteAddress(httpRequest);
            }
            String traceId = EagleEyeRequestTracer.getTraceId(httpRequest, ip);
            EagleEyeRequestTracer.startTrace(traceId, httpRequest, httpResponse);
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to startTrace from EagleEyeFilter", e);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            EagleEyeRequestTracer.endTrace(httpRequest, httpResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String uselocal = filterConfig.getInitParameter(USE_LOCAL_IP);
        if (uselocal != null && "true".equals(uselocal)) {
            this.useLocalIp = true;
        }
        EagleEye.selfLog("[INFO] " + this.getClass().getSimpleName() + " initialized successfully, useLocalIp=" + this.useLocalIp);
    }
}

