/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EagleEyeFilter2
implements Filter {
    private static final String USE_LOCAL_IP = "useLocalIp";
    private boolean useLocalIp = false;
    private boolean traceEnabled = false;
    private Method getTraceId = null;
    private Method startTrace = null;
    private Method endTrace = null;
    private Method getRemoteAddress = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.tracable(request, response)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            String ip = null;
            if (!this.useLocalIp) {
                ip = (String)this.getRemoteAddress.invoke(null, httpRequest);
            }
            String traceId = (String)this.getTraceId.invoke(null, httpRequest, ip);
            this.startTrace.invoke(null, traceId, httpRequest, httpResponse);
        }
        catch (Throwable t) {
            this.traceEnabled = false;
            System.err.println("EagleEye trace is disabled due to startTrace error: " + t.getMessage());
        }
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable throwable) {
            try {
                this.endTrace.invoke(null, httpRequest, httpResponse);
            }
            catch (Throwable t) {
                this.traceEnabled = false;
                System.err.println("EagleEye trace is disabled due to endTrace error: " + t.getMessage());
            }
            throw throwable;
        }
        try {
            this.endTrace.invoke(null, httpRequest, httpResponse);
        }
        catch (Throwable t) {
            this.traceEnabled = false;
            System.err.println("EagleEye trace is disabled due to endTrace error: " + t.getMessage());
        }
    }

    private boolean tracable(ServletRequest request, ServletResponse response) {
        return this.traceEnabled && request instanceof HttpServletRequest && response instanceof HttpServletResponse;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String uselocal = filterConfig.getInitParameter(USE_LOCAL_IP);
        if (uselocal != null && "true".equals(uselocal)) {
            this.useLocalIp = true;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName("com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeRequestTracer", true, classLoader);
            Method getTraceId = clazz.getDeclaredMethod("getTraceId", HttpServletRequest.class, String.class);
            getTraceId.setAccessible(true);
            Method startTrace = clazz.getDeclaredMethod("startTrace", String.class, HttpServletRequest.class, HttpServletResponse.class);
            startTrace.setAccessible(true);
            Method endTrace = clazz.getDeclaredMethod("endTrace", HttpServletRequest.class, HttpServletResponse.class);
            endTrace.setAccessible(true);
            Method getRemoteAddress = clazz.getDeclaredMethod("getRemoteAddress", HttpServletRequest.class);
            getRemoteAddress.setAccessible(true);
            Class<?> clazz2 = Class.forName("com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye", true, classLoader);
            Method selfLog = clazz2.getDeclaredMethod("selfLog", String.class);
            selfLog.setAccessible(true);
            selfLog.invoke(null, "[INFO] " + this.getClass().getSimpleName() + " initialized successfully, useLocalIp=" + this.useLocalIp);
            this.getTraceId = getTraceId;
            this.startTrace = startTrace;
            this.endTrace = endTrace;
            this.getRemoteAddress = getRemoteAddress;
            this.traceEnabled = true;
        }
        catch (Throwable t) {
            this.traceEnabled = false;
            System.err.println("EagleEye trace is disabled due to initialization error: " + t.getMessage());
        }
    }

    public void destroy() {
    }
}

