/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.AsyncAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class EagleEyeLogDaemon
implements Runnable {
    private static final File bizOnFile = new File(EagleEye.EAGLEEYE_LOG_DIR + "biz_eagleeye.on");
    private static final File bizOffFile = new File(EagleEye.EAGLEEYE_LOG_DIR + "biz_eagleeye.off");
    private static final File rpcOnFile = new File(EagleEye.EAGLEEYE_LOG_DIR + "rpc_eagleeye.on");
    private static final File rpcOffFile = new File(EagleEye.EAGLEEYE_LOG_DIR + "rpc_eagleeye.off");
    private static final File samplingFile = new File(EagleEye.EAGLEEYE_LOG_DIR + "eagleeye_sampling");
    private static final long LOG_CHECK_INTERVAL = TimeUnit.SECONDS.toMillis(20L);
    private static final long INDEX_FLUSH_INTERVAL = TimeUnit.HOURS.toMillis(12L);
    private static long nextIndexFlushTime = System.currentTimeMillis() + INDEX_FLUSH_INTERVAL;
    private static AtomicBoolean running = new AtomicBoolean(false);
    private static final CopyOnWriteArrayList<EagleEyeAppender> watchedAppenders = new CopyOnWriteArrayList();

    static final EagleEyeAppender watch(EagleEyeAppender appender) {
        watchedAppenders.addIfAbsent(appender);
        return appender;
    }

    static final boolean unwatch(EagleEyeAppender appender) {
        return watchedAppenders.remove(appender);
    }

    @Override
    public void run() {
        while (true) {
            this.checkFileSwitches();
            this.cleanupFiles();
            try {
                Thread.sleep(LOG_CHECK_INTERVAL);
            }
            catch (InterruptedException e) {
                EagleEye.selfLog("[ERROR] LogDeleteThread Interrupted", e);
            }
            this.outputIndexes();
            this.flushAndReload();
            this.resetExceptionThreshold();
        }
    }

    private void resetExceptionThreshold() {
        int suppressed = EagleEye.exceptionThreshold.getAndSet(0) - EagleEye.MAX_EXCEPTION_COUNT;
        if (suppressed > 0) {
            EagleEye.selfLog("[ERROR] Suppressed " + suppressed + " exceptions in last " + LOG_CHECK_INTERVAL + " millis");
        }
    }

    private void cleanupFiles() {
        for (EagleEyeAppender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.cleanup();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to cleanup: " + watchedAppender, e);
            }
        }
    }

    private void flushAndReload() {
        for (EagleEyeAppender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.reload();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to reload: " + watchedAppender, e);
            }
        }
    }

    private void outputIndexes() {
        try {
            long now = System.currentTimeMillis();
            if (now >= nextIndexFlushTime) {
                nextIndexFlushTime = now + INDEX_FLUSH_INTERVAL;
                for (Map.Entry<String, String> entry : EagleEye.indexes.entrySet()) {
                    EagleEye.index(9, entry.getValue(), entry.getKey());
                }
            }
        }
        catch (Exception e) {
            EagleEye.selfLog("[ERROR] Output index table error", e);
        }
    }

    private void checkFileSwitches() {
        try {
            if (EagleEye.isBizOff() && bizOnFile.exists()) {
                EagleEye.turnBizOn();
            } else if (!EagleEye.isBizOff() && bizOffFile.exists()) {
                EagleEye.turnBizOff();
            }
            if (EagleEye.isRpcOff() && rpcOnFile.exists()) {
                EagleEye.turnRpcOn();
            } else if (!EagleEye.isRpcOff() && rpcOffFile.exists()) {
                EagleEye.turnRpcOff();
            }
            this.readIntervalFromFile();
        }
        catch (Exception e) {
            EagleEye.selfLog("[ERROR] Check on/off file error", e);
        }
    }

    private void readIntervalFromFile() {
        String str;
        long len = samplingFile.length();
        if (len > 0L && len < 16L && (str = this.readLineFile(samplingFile)) != null && str.length() > 0) {
            try {
                int sampling = Integer.parseInt(str);
                if (sampling != EagleEye.getSamplingInterval()) {
                    EagleEye.setSamplingInterval(sampling);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readLineFile(File file) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file), 128);
            String string = br.readLine();
            return string;
        }
        catch (Exception e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    static void start() {
        if (running.compareAndSet(false, true)) {
            Thread deleteLogThread = new Thread(new EagleEyeLogDaemon());
            deleteLogThread.setDaemon(true);
            deleteLogThread.setName("EagleEye-LogCheck-Thread");
            deleteLogThread.start();
        }
    }

    static void flushAndWait() {
        for (EagleEyeAppender watchedAppender : watchedAppenders) {
            try {
                if (watchedAppender instanceof AsyncAppender) {
                    ((AsyncAppender)watchedAppender).flushAndWait();
                    continue;
                }
                watchedAppender.flush();
            }
            catch (Exception e) {
                EagleEye.selfLog("[ERROR] fail to flush: " + watchedAppender, e);
            }
        }
    }

    private EagleEyeLogDaemon() {
    }
}

