/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import com.alibaba.dts.shade.com.taobao.eagleeye.RpcContext_inner;
import com.alibaba.dts.shade.com.taobao.eagleeye.TraceIdGenerator;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EagleEyeRequestTracer {
    private static final String[] IP_HEADERS = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "X-Real-IP", "NS-Client-IP"};
    public static final String EAGLEEYE_TRACEID_PARAM_KEY = "tb_eagleeye_traceid";
    public static final String EAGLEEYE_USERDATA_PARAM_KEY = "tb_eagleeyex_";
    public static final String EAGLEEYE_TRACEID_HEADER_KEY = "EagleEye-TraceId";
    public static final String EAGLEEYE_RPCID_HEADER_KEY = "EagleEye-RpcId";
    public static final String EAGLEEYE_URL_CLASSIFIER_KEY = "i";
    public static final String EAGLEEYE_ROOT_CLASSIFIER_KEY = "r";
    private static final String LOCAL_TRACE_ID_PREFIX = EagleEye.generateTraceId(null).substring(0, 8);

    private static final boolean checkIP(String ip) {
        return ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip);
    }

    public static final String getRemoteAddress(HttpServletRequest request) {
        int index;
        String header;
        String ip = null;
        boolean valid = false;
        String[] arr$ = IP_HEADERS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(valid = EagleEyeRequestTracer.checkIP(ip = request.getHeader(header = arr$[i$]))); ++i$) {
        }
        if (!valid) {
            ip = request.getRemoteAddr();
        }
        if ((index = ip.indexOf(44)) != -1) {
            String firstIp = ip.substring(0, index).trim();
            if (EagleEyeRequestTracer.checkIP(ip)) {
                ip = firstIp;
            }
        }
        return ip;
    }

    public static final String getThreadLocalTraceId() {
        RpcContext_inner ctx = RpcContext_inner.get();
        return ctx != null ? ctx.traceId : null;
    }

    public static final String getTraceId(HttpServletRequest request) {
        return EagleEyeRequestTracer.getTraceId(request, null);
    }

    public static final String getTraceId(HttpServletRequest httpRequest, String ip) {
        String traceId = EagleEyeRequestTracer.getThreadLocalTraceId();
        if (!EagleEyeCoreUtils.isBlank(traceId)) {
            return traceId;
        }
        String queryString = httpRequest.getQueryString();
        traceId = EagleEyeRequestTracer.getParamFromUrl(queryString, EAGLEEYE_TRACEID_PARAM_KEY);
        if (!EagleEyeCoreUtils.isBlank(traceId) && traceId.length() < 64) {
            return traceId;
        }
        traceId = EagleEyeCoreUtils.trim(httpRequest.getHeader(EAGLEEYE_TRACEID_HEADER_KEY));
        if (traceId != null && traceId.length() < 64) {
            return traceId;
        }
        return TraceIdGenerator.generate(ip);
    }

    static final String getParamFromUrl(String queryString, String paramKey) {
        if (queryString != null) {
            int left = queryString.indexOf(paramKey);
            int keyEnd = left + paramKey.length() + 1;
            if (left != -1 && keyEnd < queryString.length() && queryString.charAt(keyEnd - 1) == '=' && queryString.charAt(keyEnd) != '&') {
                int right = queryString.indexOf(38, keyEnd);
                if (right != -1) {
                    return queryString.substring(keyEnd, right);
                }
                return queryString.substring(keyEnd);
            }
        }
        return null;
    }

    public static final void startTrace(String traceId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        RpcContext_inner rpcContext;
        StringBuffer sb = httpRequest.getRequestURL();
        String url = sb != null ? sb.toString() : httpRequest.getRequestURI();
        String rpcId = EagleEyeCoreUtils.trim(httpRequest.getHeader(EAGLEEYE_RPCID_HEADER_KEY));
        EagleEye.startTrace(traceId, rpcId, url);
        EagleEyeRequestTracer.processUserData(url, httpRequest);
        if (traceId != null && !traceId.startsWith(LOCAL_TRACE_ID_PREFIX) && (rpcContext = EagleEye.getRpcContext()) != null && rpcContext.getUserData(EAGLEEYE_ROOT_CLASSIFIER_KEY) == null) {
            rpcContext.putUserData(EAGLEEYE_ROOT_CLASSIFIER_KEY, EagleEyeCoreUtils.getLocalAddress());
        }
    }

    private static final void processUserData(String url, HttpServletRequest httpRequest) {
        if (!EagleEye.isUserDataEnabled()) {
            return;
        }
        if (url != null) {
            String uri = EagleEyeRequestTracer.getUriFromUrl(url);
            EagleEye.putUserData(EAGLEEYE_URL_CLASSIFIER_KEY, Integer.toHexString(uri.hashCode()));
        }
        EagleEyeRequestTracer.parseQueryString(httpRequest.getQueryString());
    }

    static void parseQueryString(String queryString) {
        if (queryString != null && queryString.length() >= 15) {
            int eq;
            int left = queryString.indexOf(EAGLEEYE_USERDATA_PARAM_KEY);
            int mapSize = 0;
            while (left != -1 && mapSize < 64 && (eq = queryString.indexOf(61, left += EAGLEEYE_USERDATA_PARAM_KEY.length())) > left) {
                String value;
                String key = queryString.substring(left, eq);
                int right = queryString.indexOf(38, eq + 1);
                if (right != -1) {
                    value = queryString.substring(eq + 1, right);
                    left = queryString.indexOf(EAGLEEYE_USERDATA_PARAM_KEY, right + 1);
                } else {
                    value = queryString.substring(eq + 1);
                    left = -1;
                }
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (key.length() == 1 && key.charAt(0) == 't') {
                    if (!EagleEye.isClusterTestEnabled()) continue;
                    EagleEye.putUserData(key, value);
                    ++mapSize;
                    continue;
                }
                EagleEye.putUserData(key, value);
                ++mapSize;
            }
        }
    }

    static String getUriFromUrl(String url) {
        int start;
        int len = url.length();
        if (len <= 7) {
            return url;
        }
        start = url.startsWith("http://") ? 7 : ((start = url.indexOf("://")) != -1 ? (start += 3) : 0);
        int end = url.charAt(len - 1) == '/' ? len - 1 : len;
        int istart = url.indexOf(47, start);
        if (istart >= 0 && istart < end) {
            return url.substring(istart, end);
        }
        return url.substring(start, end);
    }

    public static final void endTrace(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        EagleEye.endTrace();
    }

    public static final void endTrace(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String resultCode, int type) {
        EagleEye.endTrace(resultCode, type);
    }
}

