/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

class FastDateFormat {
    private static final long TIMEZONE_GMT_ADD_8_OFFSET = 28800000L;
    private static final long CURRENT_TIMEZONE_OFFSET = (long)(TimeZone.getDefault().getOffset(0L) + TimeZone.getDefault().getDSTSavings()) - 28800000L;
    private final SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private char[] buffer = new char[23];
    private long lastSecond = -1L;

    FastDateFormat() {
    }

    public String format(long timestamp) {
        this.formatToBuffer(timestamp);
        return new String(this.buffer, 0, 23);
    }

    public String format(Date date) {
        return this.format(date.getTime());
    }

    public void formatAndAppendTo(long timestamp, StringBuilder appender) {
        this.formatToBuffer(timestamp);
        appender.append(this.buffer, 0, 23);
    }

    private void formatToBuffer(long timestamp) {
        long ts = timestamp - CURRENT_TIMEZONE_OFFSET;
        long second = ts / 1000L;
        if (second == this.lastSecond) {
            int ms = (int)(ts % 1000L);
            this.buffer[22] = (char)(ms % 10 + 48);
            this.buffer[21] = (char)((ms /= 10) % 10 + 48);
            this.buffer[20] = (char)(ms / 10 + 48);
        } else {
            String result = this.fmt.format(new Date(ts));
            result.getChars(0, result.length(), this.buffer, 0);
        }
    }

    String formatWithoutMs(long timestamp) {
        long ts = timestamp - CURRENT_TIMEZONE_OFFSET;
        long second = ts / 1000L;
        if (second != this.lastSecond) {
            String result = this.fmt.format(new Date(ts));
            result.getChars(0, result.length(), this.buffer, 0);
        }
        return new String(this.buffer, 0, 19);
    }
}

