/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatEntry;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatEntryFunc;
import com.alibaba.dts.shade.com.taobao.eagleeye.StatRollingData;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class StatLogger {
    private final String loggerName;
    private final EagleEyeAppender appender;
    private final AtomicReference<StatRollingData> ref;
    private final long intervalMillis;
    private final int maxEntryCount;
    private final char entryDelimiter;
    private final char keyDelimiter;
    private final char valueDelimiter;

    StatLogger(String loggerName, EagleEyeAppender appender, long intervalMillis, int maxEntryCount, char entryDelimiter, char keyDelimiter, char valueDelimiter) {
        this.loggerName = loggerName;
        this.appender = appender;
        this.intervalMillis = intervalMillis;
        this.maxEntryCount = maxEntryCount;
        this.entryDelimiter = entryDelimiter;
        this.keyDelimiter = keyDelimiter;
        this.valueDelimiter = valueDelimiter;
        this.ref = new AtomicReference();
        this.rolling();
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    EagleEyeAppender getAppender() {
        return this.appender;
    }

    StatRollingData getRollingData() {
        return this.ref.get();
    }

    long getIntervalMillis() {
        return this.intervalMillis;
    }

    int getMaxEntryCount() {
        return this.maxEntryCount;
    }

    char getEntryDelimiter() {
        return this.entryDelimiter;
    }

    char getKeyDelimiter() {
        return this.keyDelimiter;
    }

    char getValueDelimiter() {
        return this.valueDelimiter;
    }

    StatRollingData rolling() {
        block1: {
            long rollingTimeMillis;
            long now;
            long timeSlot;
            StatRollingData nextData;
            StatRollingData prevData;
            do {
                now = System.currentTimeMillis();
                prevData = this.ref.get();
                if (prevData != null && now < prevData.getRollingTimeMillis()) break block1;
            } while (!this.ref.compareAndSet(prevData, nextData = new StatRollingData(this, new ConcurrentHashMap<StatEntry, StatEntryFunc>(), timeSlot = now - now % this.intervalMillis, rollingTimeMillis = timeSlot + this.intervalMillis)));
            return prevData;
        }
        return null;
    }

    public StatEntry stat(String key) {
        return new StatEntry(this, key);
    }

    public StatEntry stat(String key1, String key2) {
        return new StatEntry(this, key1, key2);
    }

    public StatEntry stat(String key1, String key2, String key3) {
        return new StatEntry(this, key1, key2, key3);
    }

    public StatEntry stat(String key1, String key2, String key3, String key4) {
        return new StatEntry(this, key1, key2, key3, key4);
    }

    public StatEntry stat(String key1, String ... moreKeys) {
        return new StatEntry(this, key1, moreKeys);
    }

    public StatEntry stat(List<String> keys) {
        return new StatEntry(this, keys);
    }

    public StatEntry stat(String[] keys) {
        return new StatEntry(this, keys);
    }
}

