/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity;

import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialRequester;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialService;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.Credentials;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.autokey.AutoKeyResult;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.autokey.CredentialCommand;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.autokey.CredentialPackage;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.autokey.CredentialRequest;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogger;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.sec.RSAUtils;
import com.alibaba.fastjson.JSONObject;
import java.net.InetAddress;

public class CredentialHandler {
    private static final int version = 1;
    private static final String decKey = "MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAO1YHXrr72qrbNV/5zOk7tzNeLxi8adTfFTN69+ywGGlrlfZ7pdeAb8XcQ807O23IBNyM2fnJa55spNoz2tRmkvF/z6fM8OED3F4PFTQwbphmE3OX9a4UGyLpRDE4Pp7Ay5lkEXTXjf2fkw+D4T25ekSOyS8E0/OA/rGn8+7QENFAgMBAAECgYEA1vLbWAy++nMgEMdSQ0JXFV98vdg6FJkWW9NWkHRZqNWc7HExlKKNoFuBiA0dmjgj85iUl8AOL1KF+NyOJRp1SfYWp1GigIqUOJKEIGQAXfr3f4R+CjrIcQRiSRZLKu0rrzZj7h5KSj/yYMCU4yyaSDELrzIt+rVnmld6c7dKbi0CQQD5jAmpdgO29Lf7iHwKvgmYUNxGzsN89iKwMetwieRqCFKfaB2Hs1/sLkzok2EWbB3ZcrFOCHadYmE6YZAFnqvbAkEA83tL8HVVo/8cZv/6o9eXvPnQFUPdu2HULEXqcqFqCtx3WICZ6Y7dxpn9woGfjQA5OCdg6fn4ruGDd+Ph9ZqHXwJBAPJdmyi2EQeJiINI3MiGJ8WCi15OBLmCSNB9u2Ay3OBKswxVT5Dzmy9FDLc6JKplWVxPM3tJZwKWgT31ca6zm88CQCPgojL/hywQNmYzCALGjPRqty+6/VxUMQiJEN/tSwvoqqle4c8ZnzJZlJvpr9H+G3Bb1RsFG5DhaBbtfGlNaO8CQQDXee5lC0VFMJClrH1IbtFwQTtMa9b2yGxgbQyd5yXrhD/nRuZf+CMf9d2o5JBdAWCfCfo77I0BSEnFTOQREnP2";
    private String appName;
    private CredentialService serviceInstance;
    private CredentialRequester requester;

    public CredentialHandler(String appName, CredentialService serviceInstance) {
        this.appName = appName;
        this.serviceInstance = serviceInstance;
    }

    public void setRequester(CredentialRequester requester) {
        if (this.requester == null) {
            this.requester = requester;
        }
    }

    public CredentialRequest buildRequest() {
        InetAddress addr;
        if (this.appName == null || this.appName.isEmpty()) {
            SpasLogger.warn(SpasLogCode.SPAS0063, this.appName, "Missing property project.name");
            return null;
        }
        CredentialRequest request = new CredentialRequest();
        request.setAppName(this.appName);
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            SpasLogger.error(SpasLogCode.SPAS0030, this.appName, "Failed to get local address", e);
            return null;
        }
        request.setIpAddr(addr.getHostAddress());
        request.setHostName(addr.getHostName());
        request.setVersion(1);
        return request;
    }

    public AutoKeyResult handleData(String data) {
        if (CredentialCommand.TRIGGER_REQUEST.getCommand().equals(data)) {
            this.requester.triggerRequest();
            return AutoKeyResult.getSuccess();
        }
        return this.installCredential(data);
    }

    private AutoKeyResult installCredential(String data) {
        CredentialPackage pack;
        RSAUtils decoder = new RSAUtils();
        decoder.init(2, decKey);
        String decData = decoder.decrypt(data);
        if (decData == null) {
            SpasLogger.error(SpasLogCode.SPAS0003, this.appName, "Install credential decrypt error");
            return new AutoKeyResult(1, null);
        }
        try {
            pack = (CredentialPackage)JSONObject.parseObject((String)decData, CredentialPackage.class);
        }
        catch (Exception e) {
            SpasLogger.error(SpasLogCode.SPAS0004, this.appName, "Install credential parse error");
            return new AutoKeyResult(2, null);
        }
        if (pack.getAppName() == null || !pack.getAppName().equals(this.appName)) {
            SpasLogger.error(SpasLogCode.SPAS0005, this.appName, "Install credential appName mismatch");
            return new AutoKeyResult(3, null);
        }
        Credentials credential = new Credentials(pack.getAccessKey(), pack.getSecretKey());
        this.serviceInstance.setCredential(credential);
        return AutoKeyResult.getSuccess();
    }
}

