/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity;

import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialHandler;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.autokey.AutoKeyResult;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogger;
import com.alibaba.fastjson.JSON;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class CredentialReceiver
implements Runnable {
    private String appName;
    private CredentialHandler handler;
    private Thread receiver;

    public CredentialReceiver(String appName, CredentialHandler handler) {
        this.appName = appName;
        this.handler = handler;
        this.receiver = new Thread(this);
        this.receiver.setDaemon(true);
        this.receiver.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String portStr = this.appName != null ? SpasConfigLoader.getAppProperty(this.appName, "spas.autokey.port") : SpasConfigLoader.getProperty("spas.autokey.port");
        int port = portStr != null ? Integer.parseInt(portStr) : 8204;
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
        }
        catch (Exception e) {
            SpasLogger.error(SpasLogCode.SPAS0031, this.appName, "Failed to listen to " + port, e);
            return;
        }
        while (true) {
            Socket socket;
            try {
                while (true) {
                    socket = null;
                    try {
                        socket = server.accept();
                    }
                    catch (IOException e) {
                        SpasLogger.error(SpasLogCode.SPAS0032, this.appName, "Socket connect IO error", e);
                        continue;
                    }
                    catch (Exception e) {
                        SpasLogger.error(SpasLogCode.SPAS0033, this.appName, "Socket connect error", e);
                        try {
                            server.close();
                            return;
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        return;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                try {
                    server.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                BufferedReader reader = null;
                PrintWriter writer = null;
                try {
                    OutputStream os;
                    InputStream is = socket.getInputStream();
                    if (is != null) {
                        reader = new BufferedReader(new InputStreamReader(is));
                    }
                    if ((os = socket.getOutputStream()) != null) {
                        writer = new PrintWriter(os);
                    }
                    String data = reader.readLine();
                    AutoKeyResult result = this.handler.handleData(data);
                    SpasLogger.info(this.appName, "Handle credential return " + result.getCode());
                    writer.println(JSON.toJSONString((Object)result));
                    writer.flush();
                    continue;
                }
                catch (Exception e) {
                    SpasLogger.error(SpasLogCode.SPAS0034, this.appName, "Socket communicate error", e);
                    continue;
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                    try {
                        socket.close();
                    }
                    catch (Exception e) {}
                    continue;
                }
            }
            break;
        }
    }
}

