/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity;

import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialHandler;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.autokey.CredentialRequest;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogger;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.utils.SpasHttpClient;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Timer;
import java.util.TimerTask;

public class CredentialRequester {
    private static final long REFRESH_INTERVAL = 100L;
    private static final String ENCODING = "UTF-8";
    private static final String RS_STATUS = "status";
    private static final String RS_CODE = "code";
    private Boolean needRequest = false;
    private String appName;
    private CredentialHandler handler;
    private TimerTask watcher;

    public CredentialRequester(String appName, CredentialHandler handler) {
        this.appName = appName;
        this.handler = handler;
        final String appNameF = appName;
        this.watcher = new TimerTask(){
            private Timer timer = new Timer(true);
            {
                this.timer.schedule((TimerTask)this, 100L, 100L);
            }

            public void run() {
                if (!CredentialRequester.this.needRequest.booleanValue()) {
                    return;
                }
                CredentialRequester.this.needRequest = false;
                try {
                    CredentialRequester.this.requestCredential();
                }
                catch (Exception e) {
                    SpasLogger.error(SpasLogCode.SPAS0028, appNameF, "Failed to request credential", e);
                }
            }
        };
    }

    public void triggerRequest() {
        this.needRequest = true;
    }

    public void requestCredential() {
        SpasHttpClient.HttpResult res;
        String url = SpasConfigLoader.getProperty("spas.autokey.url");
        if (url == null || url.isEmpty()) {
            SpasLogger.warn(SpasLogCode.SPAS0064, this.appName, "Missing property spas.autokey.url");
            return;
        }
        CredentialRequest request = this.handler.buildRequest();
        if (request == null) {
            SpasLogger.warn(SpasLogCode.SPAS0065, this.appName, "Build credential request failed");
            return;
        }
        String content = JSON.toJSONString((Object)request);
        try {
            res = SpasHttpClient.httpPostJson(url, null, content, ENCODING);
        }
        catch (Exception e) {
            SpasLogger.error(SpasLogCode.SPAS0029, this.appName, "Failed to send credential request", e);
            return;
        }
        if (res.code == 200) {
            try {
                JSONObject obj = JSON.parseObject((String)res.content);
                String status = obj.getString(RS_STATUS);
                String code = obj.getString(RS_CODE);
                if (!"0".equals(status) || !"0".equals(code)) {
                    SpasLogger.error(SpasLogCode.SPAS0085, this.appName, "Credential request return status " + status + " code " + code);
                }
            }
            catch (Exception e) {
                SpasLogger.error(SpasLogCode.SPAS0084, this.appName, "Credential response parse error", e);
            }
        } else {
            SpasLogger.error(SpasLogCode.SPAS0002, this.appName, "Credential request return " + res.code);
        }
    }
}

