/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity;

import com.alibaba.dts.shade.com.taobao.spas.sdk.client.CredentialListener;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialHandler;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialReceiver;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialRequester;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.CredentialWatcher;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.Credentials;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.config.SpasConfigLoader;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.identity.SpasCredentialLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class CredentialService
implements SpasCredentialLoader {
    private static ConcurrentHashMap<String, CredentialService> instances = new ConcurrentHashMap();
    private Boolean initDone = false;
    private boolean autoKey = false;
    private Credentials credentials = new Credentials();
    private CredentialWatcher watcher;
    private CredentialHandler handler;
    private CredentialRequester requester;
    private CredentialReceiver receiver;
    private CredentialListener listener;

    private CredentialService(String appName) {
        if (appName == null) {
            appName = SpasConfigLoader.getProperty("project.name");
        }
        this.watcher = new CredentialWatcher(appName, this);
        this.autoKey = "Y".equalsIgnoreCase(SpasConfigLoader.getAppProperty(appName, "spas.autokey.enable"));
        if (this.autoKey) {
            this.handler = new CredentialHandler(appName, this);
            this.requester = new CredentialRequester(appName, this.handler);
            this.handler.setRequester(this.requester);
            this.receiver = new CredentialReceiver(appName, this.handler);
        }
    }

    public static CredentialService getInstance() {
        return CredentialService.getInstance(null);
    }

    public static CredentialService getInstance(String appName) {
        CredentialService previous;
        String key = appName != null ? appName : "";
        CredentialService instance = instances.get(key);
        if (instance == null && (previous = instances.putIfAbsent(key, instance = new CredentialService(appName))) != null) {
            instance = previous;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredential() {
        Credentials localCredential = this.credentials;
        if (localCredential.valid()) {
            return localCredential;
        }
        if (!this.initDone.booleanValue()) {
            Boolean bl = this.initDone;
            synchronized (bl) {
                if (!this.initDone.booleanValue()) {
                    if (this.autoKey) {
                        this.requester.requestCredential();
                    }
                    this.initDone = true;
                }
            }
        }
        return this.credentials;
    }

    public void setCredential(Credentials credential) {
        boolean changed = this.credentials != credential && (this.credentials == null || !this.credentials.identical(credential));
        this.credentials = credential;
        if (changed && this.listener != null) {
            this.listener.onUpdateCredential();
        }
    }

    public void registerCredentialListener(CredentialListener listener) {
        this.listener = listener;
    }

    @Deprecated
    public void setAccessKey(String accessKey) {
        this.credentials.setAccessKey(accessKey);
    }

    @Deprecated
    public void setSecretKey(String secretKey) {
        this.credentials.setSecretKey(secretKey);
    }

    @Deprecated
    public String getAccessKey() {
        return this.credentials.getAccessKey();
    }

    @Deprecated
    public String getSecretKey() {
        return this.credentials.getSecretKey();
    }
}

