/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.spas.sdk.common.log;

import com.alibaba.dts.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;

public class SpasLogger {
    private static Logger logger = LoggerFactory.getLogger(SpasLogger.class);

    public static void info(String s) {
        logger.info(s);
    }

    public static void info(String appName, String s) {
        logger.info(SpasLogger.formatAppName(appName), s);
    }

    public static void warn(String s) {
        logger.warn(s);
    }

    public static void warn(String appName, String s) {
        logger.warn(SpasLogger.formatAppName(appName), s);
    }

    public static void error(String s) {
        logger.error("", s);
    }

    public static void error(String appName, String s) {
        logger.error(SpasLogger.formatAppName(appName), "", s);
    }

    public static void error(String s, Throwable throwable) {
        logger.error("", s, throwable);
    }

    public static void error(String appName, String s, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), "", s, throwable);
    }

    public static void info(SpasLogCode code, String s) {
        logger.info(SpasLogger.formatLogMessage(code, s));
    }

    public static void info(SpasLogCode code, String appName, String s) {
        logger.info(SpasLogger.formatAppName(appName), SpasLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String s) {
        logger.warn(SpasLogger.formatLogMessage(code, s));
    }

    public static void warn(SpasLogCode code, String appName, String s) {
        logger.warn(SpasLogger.formatAppName(appName), SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s) {
        logger.error("", SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String appName, String s) {
        logger.error(SpasLogger.formatAppName(appName), "", SpasLogger.formatLogMessage(code, s));
    }

    public static void error(SpasLogCode code, String s, Throwable throwable) {
        logger.error("", SpasLogger.formatLogMessage(code, s), throwable);
    }

    public static void error(SpasLogCode code, String appName, String s, Throwable throwable) {
        logger.error(SpasLogger.formatAppName(appName), "", SpasLogger.formatLogMessage(code, s), throwable);
    }

    private static String formatAppName(String appName) {
        return appName == null ? "" : appName;
    }

    private static String formatLogMessage(SpasLogCode code, String s) {
        return String.format("[SPAS-%04d] %s", code.getValue(), s);
    }

    static {
        String level = System.getProperty("spas.log.level", "INFO");
        logger.setLevel(Level.codeOf((String)level.toUpperCase()));
        logger.activateAppender("spas", "spas_sdk.log", "UTF-8");
        logger.setAdditivity(false);
    }
}

