/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz;

import com.alibaba.dts.shade.org.quartz.utils.ExceptionHelper;
import java.io.PrintStream;
import java.io.PrintWriter;

public class SchedulerException
extends Exception {
    public static final int ERR_UNSPECIFIED = 0;
    public static final int ERR_BAD_CONFIGURATION = 50;
    public static final int ERR_TIME_BROKER_FAILURE = 70;
    public static final int ERR_CLIENT_ERROR = 100;
    public static final int ERR_COMMUNICATION_FAILURE = 200;
    public static final int ERR_UNSUPPORTED_FUNCTION_IN_THIS_CONFIGURATION = 210;
    public static final int ERR_PERSISTENCE = 400;
    public static final int ERR_PERSISTENCE_JOB_DOES_NOT_EXIST = 410;
    public static final int ERR_PERSISTENCE_CALENDAR_DOES_NOT_EXIST = 420;
    public static final int ERR_PERSISTENCE_TRIGGER_DOES_NOT_EXIST = 430;
    public static final int ERR_PERSISTENCE_CRITICAL_FAILURE = 499;
    public static final int ERR_THREAD_POOL = 500;
    public static final int ERR_THREAD_POOL_EXHAUSTED = 510;
    public static final int ERR_THREAD_POOL_CRITICAL_FAILURE = 599;
    public static final int ERR_JOB_LISTENER = 600;
    public static final int ERR_JOB_LISTENER_NOT_FOUND = 610;
    public static final int ERR_TRIGGER_LISTENER = 700;
    public static final int ERR_TRIGGER_LISTENER_NOT_FOUND = 710;
    public static final int ERR_JOB_EXECUTION_THREW_EXCEPTION = 800;
    public static final int ERR_TRIGGER_THREW_EXCEPTION = 850;
    private Throwable cause;
    private int errorCode = 0;

    public SchedulerException() {
    }

    public SchedulerException(String msg) {
        super(msg);
    }

    public SchedulerException(String msg, int errorCode) {
        super(msg);
        this.setErrorCode(errorCode);
    }

    public SchedulerException(Throwable cause) {
        super(cause.toString());
        this.setCause(cause);
    }

    public SchedulerException(String msg, Throwable cause) {
        super(msg);
        this.setCause(cause);
    }

    public SchedulerException(String msg, Throwable cause, int errorCode) {
        super(msg);
        this.setCause(cause);
        this.setErrorCode(errorCode);
    }

    private void setCause(Throwable cause) {
        if (ExceptionHelper.supportsNestedThrowable()) {
            ExceptionHelper.setCause(this, cause);
        } else {
            this.cause = cause;
        }
    }

    public Throwable getUnderlyingException() {
        return ExceptionHelper.supportsNestedThrowable() ? ExceptionHelper.getCause(this) : this.cause;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public boolean isPersistenceError() {
        return this.errorCode >= 400 && this.errorCode <= 499;
    }

    public boolean isThreadPoolError() {
        return this.errorCode >= 500 && this.errorCode <= 599;
    }

    public boolean isJobListenerError() {
        return this.errorCode >= 600 && this.errorCode <= 699;
    }

    public boolean isTriggerListenerError() {
        return this.errorCode >= 700 && this.errorCode <= 799;
    }

    public boolean isClientError() {
        return this.errorCode >= 100 && this.errorCode <= 199;
    }

    public boolean isConfigurationError() {
        return this.errorCode >= 50 && this.errorCode <= 99;
    }

    public String toString() {
        Throwable cause = this.getUnderlyingException();
        if (cause == null || cause == this) {
            return super.toString();
        }
        return super.toString() + " [See nested exception: " + cause + "]";
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out) {
        super.printStackTrace(out);
        if (this.cause != null) {
            PrintStream printStream = out;
            synchronized (printStream) {
                out.println("* Nested Exception (Underlying Cause) ---------------");
                this.cause.printStackTrace(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out) {
        super.printStackTrace(out);
        if (this.cause != null) {
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                out.println("* Nested Exception (Underlying Cause) ---------------");
                this.cause.printStackTrace(out);
            }
        }
    }
}

