/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.impl.jdbcjobstore;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttributeRestoringConnectionInvocationHandler
implements InvocationHandler {
    private Connection conn;
    private boolean overwroteOriginalAutoCommitValue;
    private boolean overwroteOriginalTxIsolationValue;
    private boolean originalAutoCommitValue;
    private int originalTxIsolationValue;

    public AttributeRestoringConnectionInvocationHandler(Connection conn) {
        this.conn = conn;
    }

    protected Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("setAutoCommit")) {
            this.setAutoCommit((Boolean)args[0]);
        } else if (method.getName().equals("setTransactionIsolation")) {
            this.setTransactionIsolation((Integer)args[0]);
        } else if (method.getName().equals("close")) {
            this.close();
        } else {
            return method.invoke((Object)this.conn, args);
        }
        return null;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        boolean currentAutoCommitValue = this.conn.getAutoCommit();
        if (autoCommit != currentAutoCommitValue) {
            if (!this.overwroteOriginalAutoCommitValue) {
                this.overwroteOriginalAutoCommitValue = true;
                this.originalAutoCommitValue = currentAutoCommitValue;
            }
            this.conn.setAutoCommit(autoCommit);
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        int currentLevel = this.conn.getTransactionIsolation();
        if (level != currentLevel) {
            if (!this.overwroteOriginalTxIsolationValue) {
                this.overwroteOriginalTxIsolationValue = true;
                this.originalTxIsolationValue = currentLevel;
            }
            this.conn.setTransactionIsolation(level);
        }
    }

    public Connection getWrappedConnection() {
        return this.conn;
    }

    public void restoreOriginalAtributes() {
        try {
            if (this.overwroteOriginalAutoCommitValue) {
                this.conn.setAutoCommit(this.originalAutoCommitValue);
            }
        }
        catch (Throwable t) {
            this.getLog().warn((Object)"Failed restore connection's original auto commit setting.", t);
        }
        try {
            if (this.overwroteOriginalTxIsolationValue) {
                this.conn.setTransactionIsolation(this.originalTxIsolationValue);
            }
        }
        catch (Throwable t) {
            this.getLog().warn((Object)"Failed restore connection's original transaction isolation setting.", t);
        }
    }

    public void close() throws SQLException {
        this.restoreOriginalAtributes();
        this.conn.close();
    }
}

