/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.quartz.impl.jdbcjobstore;

import com.alibaba.dts.shade.org.quartz.impl.jdbcjobstore.Semaphore;
import java.sql.Connection;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleSemaphore
implements Semaphore {
    ThreadLocal lockOwners = new ThreadLocal();
    HashSet locks = new HashSet();
    private final Log log = LogFactory.getLog(this.getClass());

    protected Log getLog() {
        return this.log;
    }

    private HashSet getThreadLocks() {
        HashSet threadLocks = (HashSet)this.lockOwners.get();
        if (threadLocks == null) {
            threadLocks = new HashSet();
            this.lockOwners.set(threadLocks);
        }
        return threadLocks;
    }

    public synchronized boolean obtainLock(Connection conn, String lockName) {
        lockName = lockName.intern();
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock '" + lockName + "' is desired by: " + Thread.currentThread().getName()));
        }
        if (!this.isLockOwner(conn, lockName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName()));
            }
            while (this.locks.contains(lockName)) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName()));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lock '" + lockName + "' given to: " + Thread.currentThread().getName()));
            }
            this.getThreadLocks().add(lockName);
            this.locks.add(lockName);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Lock '" + lockName + "' already owned by: " + Thread.currentThread().getName() + " -- but not owner!"), (Throwable)new Exception("stack-trace of wrongful returner"));
        }
        return true;
    }

    public synchronized void releaseLock(Connection conn, String lockName) {
        if (this.isLockOwner(conn, lockName = lockName.intern())) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)("Lock '" + lockName + "' retuned by: " + Thread.currentThread().getName()));
            }
            this.getThreadLocks().remove(lockName);
            this.locks.remove(lockName);
            this.notifyAll();
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Lock '" + lockName + "' attempt to retun by: " + Thread.currentThread().getName() + " -- but not owner!"), (Throwable)new Exception("stack-trace of wrongful returner"));
        }
    }

    public synchronized boolean isLockOwner(Connection conn, String lockName) {
        lockName = lockName.intern();
        return this.getThreadLocks().contains(lockName);
    }

    public boolean requiresConnection() {
        return false;
    }
}

